/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import java.util.Collections;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public interface CassandraBatchOperations {
    public WriteResult execute();

    @Contract(value="_ -> this")
    public CassandraBatchOperations withTimestamp(long var1);

    @Contract(value="_ -> this")
    public CassandraBatchOperations withQueryOptions(QueryOptions var1);

    @Contract(value="_ -> this")
    public CassandraBatchOperations addStatement(BatchableStatement<?> var1);

    @Contract(value="_ -> this")
    public CassandraBatchOperations addStatements(BatchableStatement<?> ... var1);

    @Contract(value="_ -> this")
    public CassandraBatchOperations addStatements(Iterable<? extends BatchableStatement<?>> var1);

    @Contract(value="_, _ -> this")
    default public CassandraBatchOperations insert(Object entity, WriteOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        return this.insert(Collections.singleton(entity), options);
    }

    @Contract(value="_ -> this")
    public CassandraBatchOperations insert(Object ... var1);

    @Contract(value="_ -> this")
    public CassandraBatchOperations insert(Iterable<?> var1);

    @Contract(value="_, _ -> this")
    public CassandraBatchOperations insert(Iterable<?> var1, WriteOptions var2);

    @Contract(value="_, _ -> this")
    default public CassandraBatchOperations update(Object entity, WriteOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        return this.update(Collections.singleton(entity), options);
    }

    @Contract(value="_ -> this")
    public CassandraBatchOperations update(Object ... var1);

    @Contract(value="_ -> this")
    public CassandraBatchOperations update(Iterable<?> var1);

    @Contract(value="_, _ -> this")
    public CassandraBatchOperations update(Iterable<?> var1, WriteOptions var2);

    @Contract(value="_, _ -> this")
    default public CassandraBatchOperations delete(Object entity, WriteOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        return this.delete(Collections.singleton(entity), options);
    }

    @Contract(value="_ -> this")
    public CassandraBatchOperations delete(Object ... var1);

    @Contract(value="_ -> this")
    public CassandraBatchOperations delete(Iterable<?> var1);

    @Contract(value="_, _ -> this")
    public CassandraBatchOperations delete(Iterable<?> var1, WriteOptions var2);
}

