/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.aot;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.data.aot.ManagedTypesBeanRegistrationAotProcessor;
import org.springframework.data.cassandra.CassandraManagedTypes;
import org.springframework.data.util.Predicates;
import org.springframework.data.util.TypeCollector;
import org.springframework.data.util.TypeUtils;
import org.springframework.util.ClassUtils;

class CassandraManagedTypesBeanRegistrationAotProcessor
extends ManagedTypesBeanRegistrationAotProcessor {
    public CassandraManagedTypesBeanRegistrationAotProcessor() {
        this.setModuleIdentifier("cassandra");
    }

    protected boolean matchesByType(@Nullable Class<?> beanType) {
        return beanType != null && ClassUtils.isAssignable(CassandraManagedTypes.class, beanType);
    }

    static class CassandraTypeFilters
    implements TypeCollector.TypeCollectorFilters {
        private static final Predicate<Class<?>> CLASS_FILTER = it -> TypeUtils.type((Class)it).isPartOf(new String[]{"org.springframework.data.cassandra.core", "org.springframework.data.cassandra.repository", "org.apache.cassandra", "com.datastax"});

        CassandraTypeFilters() {
        }

        public Predicate<Class<?>> classPredicate() {
            return CLASS_FILTER.negate();
        }

        public Predicate<Field> fieldPredicate() {
            return Predicates.declaringClass(CLASS_FILTER).negate();
        }

        public Predicate<Method> methodPredicate() {
            return Predicates.declaringClass(CLASS_FILTER).negate();
        }
    }
}

