/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Limit;
import org.springframework.data.expression.ValueExpression;
import org.springframework.data.repository.query.Parameter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ParameterBinding {
    private final BindingIdentifier identifier;
    private final ParameterOrigin origin;

    protected ParameterBinding(BindingIdentifier identifier, ParameterOrigin origin) {
        Assert.notNull((Object)identifier, (String)"BindingIdentifier must not be null");
        Assert.notNull((Object)origin, (String)"ParameterOrigin must not be null");
        this.identifier = identifier;
        this.origin = origin;
    }

    public static ParameterBinding of(Parameter parameter) {
        return ParameterBinding.named(parameter.getRequiredName(), ParameterOrigin.ofParameter(parameter));
    }

    public static ParameterBinding named(String name, ParameterOrigin origin) {
        return new ParameterBinding(BindingIdentifier.of(name), origin);
    }

    public static ParameterBinding named(String name) {
        BindingIdentifier id = BindingIdentifier.of(name);
        return new ParameterBinding(id, new MethodInvocationArgument(id));
    }

    public static ParameterBinding indexed(int position) {
        BindingIdentifier id = BindingIdentifier.of(position);
        return new ParameterBinding(id, new MethodInvocationArgument(id));
    }

    public static ParameterBinding expression(ValueExpression expression) {
        return new ParameterBinding(BindingIdentifier.anonymous(), new Expression(expression));
    }

    public BindingIdentifier getIdentifier() {
        return this.identifier;
    }

    public ParameterOrigin getOrigin() {
        return this.origin;
    }

    public @Nullable String getName() {
        return this.identifier.hasName() ? this.identifier.getName() : null;
    }

    boolean hasName() {
        return this.identifier.hasName();
    }

    String getRequiredName() throws IllegalStateException {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        throw new IllegalStateException(String.format("Required name for %s not available", this));
    }

    @Nullable Integer getPosition() {
        return this.identifier.hasPosition() ? Integer.valueOf(this.identifier.getPosition()) : null;
    }

    int getRequiredPosition() throws IllegalStateException {
        Integer position = this.getPosition();
        if (position != null) {
            return position;
        }
        throw new IllegalStateException(String.format("Required position for %s not available", this));
    }

    public @Nullable Object prepareValue(@Nullable Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof Limit) {
            Limit limit = (Limit)value;
            return limit.max();
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterBinding that = (ParameterBinding)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.identifier, (Object)that.identifier)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.origin, (Object)that.origin);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.identifier);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.origin);
        return result;
    }

    public String toString() {
        return String.format("ParameterBinding [identifier: %s, origin: %s]", this.identifier, this.origin);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface BindingIdentifier {
        public static BindingIdentifier anonymous() {
            return Anonymous.ANONYMOUS;
        }

        public static BindingIdentifier of(String name) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            return new Named(name);
        }

        public static BindingIdentifier of(int position) {
            Assert.isTrue((position > -1 ? 1 : 0) != 0, (String)"Index position must be greater zero");
            return new Indexed(position);
        }

        public static BindingIdentifier of(String name, int position) {
            Assert.hasText((String)name, (String)"Name must not be empty");
            return new NamedAndIndexed(name, position);
        }

        default public boolean hasName() {
            return false;
        }

        default public boolean hasPosition() {
            return false;
        }

        default public String getName() {
            throw new IllegalStateException("No name associated");
        }

        default public int getPosition() {
            throw new IllegalStateException("No position associated");
        }

        public BindingIdentifier mapName(Function<? super String, ? extends String> var1);

        public BindingIdentifier withPosition(int var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ParameterOrigin {
        public static Expression ofExpression(ValueExpression expression) {
            return new Expression(expression);
        }

        public static Synthetic synthetic(@Nullable Object value, Object source) {
            return new Synthetic(value, source);
        }

        public static MethodInvocationArgument ofParameter(String name) {
            return ParameterOrigin.ofParameter(name, null);
        }

        public static MethodInvocationArgument ofParameter(@Nullable String name, @Nullable Integer position) {
            BindingIdentifier identifier;
            if (!ObjectUtils.isEmpty((Object)name) && position != null) {
                identifier = BindingIdentifier.of(name, position);
            } else if (!ObjectUtils.isEmpty((Object)name)) {
                identifier = BindingIdentifier.of(name);
            } else if (position != null) {
                identifier = BindingIdentifier.of(position);
            } else {
                throw new IllegalStateException("Neither name nor position available for binding");
            }
            return ParameterOrigin.ofParameter(identifier);
        }

        public static MethodInvocationArgument ofParameter(Parameter parameter) {
            return ParameterOrigin.ofParameter(parameter.getIndex() + 1);
        }

        public static MethodInvocationArgument ofParameter(int position) {
            return ParameterOrigin.ofParameter(BindingIdentifier.of(position));
        }

        public static MethodInvocationArgument ofParameter(BindingIdentifier identifier) {
            return new MethodInvocationArgument(identifier);
        }

        public boolean isMethodArgument();

        public boolean isExpression();

        public boolean isSynthetic();
    }

    public record MethodInvocationArgument(BindingIdentifier identifier) implements ParameterOrigin
    {
        @Override
        public boolean isMethodArgument() {
            return true;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public boolean isSynthetic() {
            return false;
        }
    }

    public record Expression(ValueExpression expression) implements ParameterOrigin
    {
        @Override
        public boolean isMethodArgument() {
            return false;
        }

        @Override
        public boolean isExpression() {
            return true;
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }
    }

    public record Synthetic(@Nullable Object value, Object source) implements ParameterOrigin
    {
        @Override
        public boolean isMethodArgument() {
            return false;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public boolean isSynthetic() {
            return true;
        }
    }

    private record NamedAndIndexed(String name, int position) implements BindingIdentifier
    {
        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public boolean hasPosition() {
            return true;
        }

        @Override
        public int getPosition() {
            return this.position();
        }

        @Override
        public BindingIdentifier mapName(Function<? super String, ? extends String> nameMapper) {
            return new NamedAndIndexed(nameMapper.apply(this.name), this.position);
        }

        @Override
        public BindingIdentifier withPosition(int position) {
            return new NamedAndIndexed(this.name, position);
        }

        @Override
        public String toString() {
            return "[" + this.name() + ", " + this.position() + "]";
        }
    }

    private record Indexed(int position) implements BindingIdentifier
    {
        @Override
        public boolean hasPosition() {
            return true;
        }

        @Override
        public int getPosition() {
            return this.position();
        }

        @Override
        public BindingIdentifier mapName(Function<? super String, ? extends String> nameMapper) {
            return this;
        }

        @Override
        public BindingIdentifier withPosition(int position) {
            return new Indexed(position);
        }

        @Override
        public String toString() {
            return "[" + this.position() + "]";
        }
    }

    private record Named(String name) implements BindingIdentifier
    {
        @Override
        public boolean hasName() {
            return true;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String toString() {
            return this.name();
        }

        @Override
        public BindingIdentifier mapName(Function<? super String, ? extends String> nameMapper) {
            return new Named(nameMapper.apply(this.name()));
        }

        @Override
        public BindingIdentifier withPosition(int position) {
            return new NamedAndIndexed(this.name, position);
        }
    }

    static enum Anonymous implements BindingIdentifier
    {
        ANONYMOUS;


        public String toString() {
            return "?";
        }

        @Override
        public BindingIdentifier mapName(Function<? super String, ? extends String> nameMapper) {
            return this;
        }

        @Override
        public BindingIdentifier withPosition(int position) {
            return new Indexed(position);
        }
    }
}

