/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.session.init;

import com.datastax.oss.driver.api.core.CqlSession;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.cql.session.init.KeyspacePopulator;
import org.springframework.data.cassandra.core.cql.session.init.ScriptException;
import org.springframework.data.cassandra.core.cql.session.init.ScriptUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ResourceKeyspacePopulator
implements KeyspacePopulator {
    List<Resource> scripts = new ArrayList<Resource>();
    private @Nullable String cqlScriptEncoding;
    private String separator = ";";
    private String[] commentPrefixes = ScriptUtils.DEFAULT_COMMENT_PREFIXES;
    private String blockCommentStartDelimiter = "/*";
    private String blockCommentEndDelimiter = "*/";
    private boolean continueOnError = false;
    private boolean ignoreFailedDrops = false;

    public ResourceKeyspacePopulator() {
    }

    public ResourceKeyspacePopulator(Resource ... scripts) {
        this.setScripts(scripts);
    }

    public ResourceKeyspacePopulator(boolean continueOnError, boolean ignoreFailedDrops, @Nullable String cqlScriptEncoding, Resource ... scripts) {
        this.continueOnError = continueOnError;
        this.ignoreFailedDrops = ignoreFailedDrops;
        this.setCqlScriptEncoding(cqlScriptEncoding);
        this.setScripts(scripts);
    }

    public void addScript(Resource script) {
        Assert.notNull((Object)script, (String)"'script' must not be null");
        this.scripts.add(script);
    }

    public void addScripts(Resource ... scripts) {
        this.assertContentsOfScriptArray(scripts);
        this.scripts.addAll(Arrays.asList(scripts));
    }

    public void setScripts(Resource ... scripts) {
        this.assertContentsOfScriptArray(scripts);
        this.scripts = new ArrayList<Resource>(Arrays.asList(scripts));
    }

    private void assertContentsOfScriptArray(Resource ... scripts) {
        Assert.notNull((Object)scripts, (String)"'scripts' must not be null");
        Assert.noNullElements((Object[])scripts, (String)"'scripts' must not contain null elements");
    }

    public void setCqlScriptEncoding(@Nullable String cqlScriptEncoding) {
        this.cqlScriptEncoding = StringUtils.hasText((String)cqlScriptEncoding) ? cqlScriptEncoding : null;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setCommentPrefix(String commentPrefix) {
        Assert.hasText((String)commentPrefix, (String)"'commentPrefix' must not be null or empty");
        this.commentPrefixes = new String[]{commentPrefix};
    }

    public void setCommentPrefixes(String ... commentPrefixes) {
        Assert.notEmpty((Object[])commentPrefixes, (String)"'commentPrefixes' must not be null or empty");
        Assert.noNullElements((Object[])commentPrefixes, (String)"'commentPrefixes' must not contain null elements");
        this.commentPrefixes = commentPrefixes;
    }

    public void setBlockCommentStartDelimiter(String blockCommentStartDelimiter) {
        Assert.hasText((String)blockCommentStartDelimiter, (String)"'blockCommentStartDelimiter' must not be null or empty");
        this.blockCommentStartDelimiter = blockCommentStartDelimiter;
    }

    public void setBlockCommentEndDelimiter(String blockCommentEndDelimiter) {
        Assert.hasText((String)blockCommentEndDelimiter, (String)"'blockCommentEndDelimiter' must not be null or empty");
        this.blockCommentEndDelimiter = blockCommentEndDelimiter;
    }

    public void setContinueOnError(boolean continueOnError) {
        this.continueOnError = continueOnError;
    }

    public void setIgnoreFailedDrops(boolean ignoreFailedDrops) {
        this.ignoreFailedDrops = ignoreFailedDrops;
    }

    @Override
    public void populate(CqlSession session) throws ScriptException {
        Assert.notNull((Object)session, (String)"session must not be null");
        for (Resource script : this.scripts) {
            EncodedResource encodedScript = new EncodedResource(script, this.cqlScriptEncoding);
            ScriptUtils.executeCqlScript(session, encodedScript, this.continueOnError, this.ignoreFailedDrops, this.commentPrefixes, this.separator, this.blockCommentStartDelimiter, this.blockCommentEndDelimiter);
        }
    }

    public void execute(SessionFactory sessionFactory) throws ScriptException {
        this.populate(sessionFactory.getSession());
    }
}

