/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.data.cassandra.core.query.SerializationUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class Update {
    private static final Update EMPTY = new Update(Collections.emptyMap());
    private final Map<ColumnName, AssignmentOp> updateOperations;

    public static Update empty() {
        return EMPTY;
    }

    public static Update of(Iterable<AssignmentOp> assignmentOps) {
        Assert.notNull(assignmentOps, (String)"Update operations must not be null");
        LinkedHashMap<ColumnName, AssignmentOp> updateOperations = assignmentOps instanceof Collection ? new LinkedHashMap<ColumnName, AssignmentOp>(((Collection)assignmentOps).size()) : new LinkedHashMap();
        assignmentOps.forEach(assignmentOp -> updateOperations.put(assignmentOp.getColumnName(), (AssignmentOp)assignmentOp));
        return new Update(updateOperations);
    }

    public static Update update(String columnName, @Nullable Object value) {
        return Update.empty().set(columnName, value);
    }

    private Update(Map<ColumnName, AssignmentOp> updateOperations) {
        this.updateOperations = updateOperations;
    }

    public Update set(String columnName, @Nullable Object value) {
        return this.add(new SetOp(ColumnName.from(columnName), value));
    }

    public SetBuilder set(String columnName) {
        return new DefaultSetBuilder(ColumnName.from(columnName));
    }

    public AddToBuilder addTo(String columnName) {
        return new DefaultAddToBuilder(ColumnName.from(columnName));
    }

    public RemoveFromBuilder removeFrom(String columnName) {
        return new DefaultRemoveFromBuilder(ColumnName.from(columnName));
    }

    public Update remove(String columnName, Object value) {
        return this.add(new RemoveOp(ColumnName.from(columnName), Collections.singletonList(value)));
    }

    public Update clear(String columnName) {
        return this.add(new SetOp(ColumnName.from(columnName), Collections.emptyList()));
    }

    public Update increment(String columnName) {
        return this.increment(columnName, 1);
    }

    public Update increment(String columnName, Number delta) {
        return this.add(new IncrOp(ColumnName.from(columnName), delta));
    }

    public Update decrement(String columnName) {
        return this.decrement(columnName, 1);
    }

    public Update decrement(String columnName, Number delta) {
        if (delta instanceof Integer || delta instanceof Long) {
            long deltaValue = delta.longValue() > 0L ? -Math.abs(delta.longValue()) : delta.longValue();
            return this.add(new IncrOp(ColumnName.from(columnName), deltaValue));
        }
        double deltaValue = delta.doubleValue();
        deltaValue = deltaValue > 0.0 ? -Math.abs(deltaValue) : deltaValue;
        return this.add(new IncrOp(ColumnName.from(columnName), deltaValue));
    }

    public Collection<AssignmentOp> getUpdateOperations() {
        return Collections.unmodifiableCollection(this.updateOperations.values());
    }

    private Update add(AssignmentOp assignmentOp) {
        LinkedHashMap<ColumnName, AssignmentOp> map = new LinkedHashMap<ColumnName, AssignmentOp>(this.updateOperations.size() + 1);
        map.putAll(this.updateOperations);
        map.put(assignmentOp.getColumnName(), assignmentOp);
        return new Update(map);
    }

    public String toString() {
        return StringUtils.collectionToDelimitedString(this.updateOperations.values(), (String)", ");
    }

    public static class SetOp
    extends AssignmentOp {
        private final @Nullable Object value;

        public SetOp(ColumnName columnName, @Nullable Object value) {
            super(columnName);
            this.value = value;
        }

        public @Nullable Object getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s", this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.value));
        }
    }

    public static abstract class AssignmentOp {
        private final ColumnName columnName;

        protected AssignmentOp(ColumnName columnName) {
            this.columnName = columnName;
        }

        public ColumnName getColumnName() {
            return this.columnName;
        }

        public CqlIdentifier toCqlIdentifier() {
            return this.columnName.getCqlIdentifier().orElseGet(() -> CqlIdentifier.fromCql((String)this.columnName.toCql()));
        }
    }

    private class DefaultSetBuilder
    implements SetBuilder {
        private final ColumnName columnName;

        DefaultSetBuilder(ColumnName columnName) {
            this.columnName = columnName;
        }

        @Override
        public SetValueBuilder atIndex(int index) {
            return value -> Update.this.add(new SetAtIndexOp(this.columnName, index, value));
        }

        @Override
        public SetValueBuilder atKey(Object key) {
            return value -> Update.this.add(new SetAtKeyOp(this.columnName, key, value));
        }
    }

    private class DefaultAddToBuilder
    implements AddToBuilder {
        private final ColumnName columnName;

        DefaultAddToBuilder(ColumnName columnName) {
            this.columnName = columnName;
        }

        @Override
        public Update prepend(Object value) {
            return this.prependAll(Collections.singletonList(value));
        }

        @Override
        public Update prependAll(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null");
            return this.prependAll(Arrays.asList(values));
        }

        @Override
        public Update prependAll(Iterable<? extends Object> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return Update.this.add(new AddToOp(this.columnName, values, AddToOp.Mode.PREPEND));
        }

        @Override
        public Update append(Object value) {
            return this.appendAll(Collections.singletonList(value));
        }

        @Override
        public Update appendAll(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null");
            return this.appendAll(Arrays.asList(values));
        }

        @Override
        public Update appendAll(Iterable<? extends Object> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return Update.this.add(new AddToOp(this.columnName, values, AddToOp.Mode.APPEND));
        }

        @Override
        public Update entry(Object key, Object value) {
            Assert.notNull((Object)key, (String)"Key must not be null");
            Assert.notNull((Object)value, (String)"Value must not be null");
            return this.addAll(Collections.singletonMap(key, value));
        }

        public Update addAll(Map<?, ?> map) {
            Assert.notNull(map, (String)"Map must not be null");
            return Update.this.add(new AddToMapOp(this.columnName, map));
        }
    }

    private class DefaultRemoveFromBuilder
    implements RemoveFromBuilder {
        private final ColumnName columnName;

        DefaultRemoveFromBuilder(ColumnName columnName) {
            this.columnName = columnName;
        }

        @Override
        public Update value(Object value) {
            return Update.this.add(new RemoveOp(this.columnName, value));
        }

        public Update values(Iterable<?> values) {
            Assert.notNull(values, (String)"Values must not be null");
            return Update.this.add(new RemoveOp(this.columnName, values));
        }
    }

    public static class RemoveOp
    extends AssignmentOp {
        private final Object value;

        public RemoveOp(ColumnName columnName, Object value) {
            super(columnName);
            Assert.notNull((Object)value, (String)"Value must not be null");
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s - %s", this.getColumnName(), this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.getValue()));
        }
    }

    public static class IncrOp
    extends AssignmentOp {
        private final Number value;

        public IncrOp(ColumnName columnName, Number value) {
            super(columnName);
            this.value = value;
        }

        public Number getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s %s %d", this.getColumnName(), this.getColumnName(), this.value.doubleValue() > 0.0 ? "+" : "-", Math.abs(this.value.longValue()));
        }
    }

    public static class SetAtKeyOp
    extends SetOp {
        private final Object key;
        private final Object value;

        public SetAtKeyOp(ColumnName columnName, Object key, Object value) {
            super(columnName, value);
            Assert.notNull((Object)key, (String)"Key must not be null");
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String toString() {
            return String.format("%s[%s] = %s", this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.key), SerializationUtils.serializeToCqlSafely(this.getValue()));
        }
    }

    public static class SetAtIndexOp
    extends SetOp {
        private final int index;

        public SetAtIndexOp(ColumnName columnName, int index, Object value) {
            super(columnName, value);
            Assert.notNull((Object)value, (String)"Value must not be null");
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public String toString() {
            return String.format("%s[%d] = %s", this.getColumnName(), this.index, SerializationUtils.serializeToCqlSafely(this.getValue()));
        }
    }

    public static class AddToMapOp
    extends AssignmentOp {
        private final Map<Object, Object> value;

        public AddToMapOp(ColumnName columnName, Map<? extends Object, ? extends Object> value) {
            super(columnName);
            this.value = value;
        }

        public Map<Object, Object> getValue() {
            return this.value;
        }

        public String toString() {
            return String.format("%s = %s + %s", this.getColumnName(), this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.value));
        }
    }

    public static class AddToOp
    extends AssignmentOp {
        private final Iterable<Object> value;
        private final Mode mode;

        public AddToOp(ColumnName columnName, Iterable<? extends Object> value, Mode mode) {
            super(columnName);
            this.value = value;
            this.mode = mode;
        }

        public Iterable<Object> getValue() {
            return this.value;
        }

        public Mode getMode() {
            return this.mode;
        }

        public String toString() {
            return Mode.PREPEND.equals((Object)this.getMode()) ? String.format("%s = %s + %s", this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.value), this.getColumnName()) : String.format("%s = %s + %s", this.getColumnName(), this.getColumnName(), SerializationUtils.serializeToCqlSafely(this.value));
        }

        public static enum Mode {
            PREPEND,
            APPEND;

        }
    }

    public static interface SetValueBuilder {
        public Update to(Object var1);
    }

    public static interface SetBuilder {
        public SetValueBuilder atIndex(int var1);

        public SetValueBuilder atKey(Object var1);
    }

    public static interface RemoveFromBuilder {
        public Update value(Object var1);

        default public Update values(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null");
            return this.values(Arrays.asList(values));
        }

        public Update values(Iterable<? extends Object> var1);
    }

    public static interface AddToBuilder {
        public Update prepend(Object var1);

        public Update prependAll(Object ... var1);

        public Update prependAll(Iterable<? extends Object> var1);

        public Update append(Object var1);

        public Update appendAll(Object ... var1);

        public Update appendAll(Iterable<? extends Object> var1);

        public Update entry(Object var1, Object var2);

        public Update addAll(Map<? extends Object, ? extends Object> var1);
    }
}

