/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.data.CqlVector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.data.cassandra.core.convert.CassandraVector;
import org.springframework.data.cassandra.core.mapping.SimilarityFunction;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.data.domain.Vector;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Columns
implements Iterable<ColumnName> {
    private final Map<ColumnName, List<Selector>> columns;

    private Columns(Map<ColumnName, List<Selector>> columns) {
        this.columns = Collections.unmodifiableMap(columns);
    }

    public static Columns empty() {
        return new Columns(Collections.emptyMap());
    }

    public static Columns from(String ... columnNames) {
        Assert.notNull((Object)columnNames, (String)"Column names must not be null");
        LinkedHashMap<ColumnName, List<Selector>> columns = new LinkedHashMap<ColumnName, List<Selector>>(columnNames.length, 1.0f);
        for (String columnName : columnNames) {
            columns.put(ColumnName.from(columnName), new ArrayList<ColumnSelector>(List.of(ColumnSelector.from(columnName))));
        }
        return new Columns(columns);
    }

    public static Columns from(CqlIdentifier ... columnNames) {
        Assert.notNull((Object)columnNames, (String)"Column names must not be null");
        LinkedHashMap<ColumnName, List<Selector>> columns = new LinkedHashMap<ColumnName, List<Selector>>(columnNames.length, 1.0f);
        for (CqlIdentifier cqlId : columnNames) {
            columns.put(ColumnName.from(cqlId), new ArrayList<ColumnSelector>(List.of(ColumnSelector.from(cqlId))));
        }
        return new Columns(columns);
    }

    public Columns include(String columnName) {
        return this.select(columnName, (Selector)ColumnSelector.from(columnName));
    }

    public Columns include(CqlIdentifier columnName) {
        return this.select(columnName, (Selector)ColumnSelector.from(columnName));
    }

    public Columns ttl(String columnName) {
        return this.select(columnName, (Selector)FunctionCall.from("TTL", ColumnSelector.from(columnName)));
    }

    public Columns ttl(CqlIdentifier columnName) {
        return this.select(columnName, (Selector)FunctionCall.from("TTL", ColumnSelector.from(columnName)));
    }

    public Columns select(String columnName, Selector selector) {
        return this.select(ColumnName.from(columnName), selector);
    }

    public Columns select(CqlIdentifier columnName, Function<SelectorBuilder, Selector> builder) {
        ColumnName from = ColumnName.from(columnName);
        return this.select(from, builder.apply(new DefaultSelectorBuilder(from)));
    }

    public Columns select(String columnName, Function<SelectorBuilder, Selector> builder) {
        ColumnName from = ColumnName.from(columnName);
        return this.select(from, builder.apply(new DefaultSelectorBuilder(from)));
    }

    public Columns select(CqlIdentifier columnName, Selector selector) {
        return this.select(ColumnName.from(columnName), selector);
    }

    private Columns select(ColumnName columnName, Selector selector) {
        LinkedHashMap<ColumnName, List<Selector>> result = new LinkedHashMap<ColumnName, List<Selector>>(this.columns);
        result.computeIfAbsent(columnName, it -> new ArrayList()).add(selector);
        return new Columns(result);
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    public Columns and(Columns columns) {
        LinkedHashMap<ColumnName, List<Selector>> result = new LinkedHashMap<ColumnName, List<Selector>>(this.columns);
        columns.columns.forEach((? super K col, ? super V selectors) -> result.computeIfAbsent((ColumnName)col, columnName -> new ArrayList()).addAll(selectors));
        return new Columns(result);
    }

    @Override
    public Iterator<ColumnName> iterator() {
        return this.columns.keySet().iterator();
    }

    public List<Selector> getSelector(ColumnName columnName) {
        Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
        List<Selector> selectors = this.columns.get(columnName);
        return selectors == null ? List.of() : selectors;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Columns)) {
            return false;
        }
        Columns that = (Columns)object;
        return this.columns.equals(that.columns);
    }

    public int hashCode() {
        int result = 17;
        return result += 31 * ObjectUtils.nullSafeHashCode(this.columns);
    }

    public String toString() {
        Iterator<Map.Entry<ColumnName, List<Selector>>> iterator = this.columns.entrySet().iterator();
        StringBuilder builder = this.toString(iterator);
        if (builder.isEmpty()) {
            return "*";
        }
        return builder.toString();
    }

    private StringBuilder toString(Iterator<Map.Entry<ColumnName, List<Selector>>> iterator) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        while (iterator.hasNext()) {
            Map.Entry<ColumnName, List<Selector>> entry = iterator.next();
            for (Selector selector : entry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(selector);
            }
        }
        return builder;
    }

    public static class ColumnSelector
    implements Selector {
        private final ColumnName columnName;
        private final Optional<CqlIdentifier> alias;

        ColumnSelector(ColumnName columnName) {
            Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
            this.columnName = columnName;
            this.alias = Optional.empty();
        }

        ColumnSelector(ColumnName columnName, CqlIdentifier alias) {
            Assert.notNull((Object)columnName, (String)"ColumnName must not be null");
            Assert.notNull((Object)alias, (String)"Alias must not be null");
            this.columnName = columnName;
            this.alias = Optional.of(alias);
        }

        public static ColumnSelector from(ColumnName columnName) {
            return new ColumnSelector(columnName);
        }

        public static ColumnSelector from(CqlIdentifier columnName) {
            return ColumnSelector.from(ColumnName.from(columnName));
        }

        public static ColumnSelector from(String columnName) {
            return ColumnSelector.from(ColumnName.from(columnName));
        }

        @Override
        public ColumnSelector as(CqlIdentifier alias) {
            return new ColumnSelector(this.columnName, alias);
        }

        @Override
        public Optional<CqlIdentifier> getAlias() {
            return this.alias;
        }

        public CqlIdentifier getIdentifier() {
            return this.columnName.getCqlIdentifier().orElseGet(() -> CqlIdentifier.fromCql((String)this.columnName.toCql()));
        }

        @Override
        public String getExpression() {
            return this.columnName.toCql();
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ColumnSelector)) {
                return false;
            }
            ColumnSelector that = (ColumnSelector)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.columnName, (Object)that.columnName)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.alias, that.alias);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.columnName);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.alias);
            return result;
        }

        public String toString() {
            return this.getAlias().map(cqlIdentifier -> String.format("%s AS %s", this.getExpression(), cqlIdentifier)).orElseGet(this::getExpression);
        }
    }

    public static interface Selector {
        default public Selector as(String alias) {
            return this.as(CqlIdentifier.fromCql((String)alias));
        }

        public Selector as(CqlIdentifier var1);

        public String getExpression();

        public Optional<CqlIdentifier> getAlias();
    }

    public static class FunctionCall
    implements Selector {
        private final String expression;
        private final List<Object> params;
        private final Optional<CqlIdentifier> alias;

        FunctionCall(String expression, List<Object> params) {
            this.expression = expression;
            this.params = params;
            this.alias = Optional.empty();
        }

        private FunctionCall(String expression, List<Object> params, CqlIdentifier alias) {
            this.expression = expression;
            this.params = params;
            this.alias = Optional.of(alias);
        }

        public static FunctionCall from(String expression, Object ... params) {
            return new FunctionCall(expression, Arrays.asList(params));
        }

        @Override
        public FunctionCall as(CqlIdentifier alias) {
            return new FunctionCall(this.expression, this.params, alias);
        }

        FunctionCall as(ColumnName alias) {
            return new FunctionCall(this.expression, this.params, alias.getRequiredCqlIdentifier());
        }

        @Override
        public String getExpression() {
            return this.expression;
        }

        @Override
        public Optional<CqlIdentifier> getAlias() {
            return this.alias;
        }

        public List<Object> getParameters() {
            return this.params;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FunctionCall)) {
                return false;
            }
            FunctionCall that = (FunctionCall)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.expression, (Object)that.expression)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals(this.params, that.params)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.alias, that.alias);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.expression);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.params);
            result = 31 * result + ObjectUtils.nullSafeHashCode(this.alias);
            return result;
        }

        public String toString() {
            String parameters = StringUtils.collectionToDelimitedString(this.getParameters(), (String)", ");
            return this.getAlias().map(cqlIdentifier -> String.format("%s(%s) AS %s", this.getExpression(), parameters, cqlIdentifier)).orElseGet(() -> String.format("%s(%s)", this.getExpression(), parameters));
        }
    }

    static class DefaultSelectorBuilder
    implements SelectorBuilder {
        private final ColumnName columnName;

        DefaultSelectorBuilder(ColumnName columnName) {
            this.columnName = columnName;
        }

        @Override
        public Selector column() {
            return new ColumnSelector(this.columnName);
        }

        @Override
        public Selector ttl() {
            return FunctionCall.from("TTL", ColumnSelector.from(this.columnName)).as(this.columnName);
        }

        @Override
        public SimilarityBuilder similarity(CqlVector<?> vector) {
            return this.similarity(CassandraVector.of(vector));
        }

        @Override
        public SimilarityBuilder similarity(final Vector vector) {
            Assert.notNull((Object)vector, (String)"Vector must not be null");
            return new SimilarityBuilder(){
                final /* synthetic */ DefaultSelectorBuilder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Selector cosine() {
                    return this.using(SimilarityFunction.COSINE);
                }

                @Override
                public Selector euclidean() {
                    return this.using(SimilarityFunction.EUCLIDEAN);
                }

                @Override
                public Selector dotProduct() {
                    return this.using(SimilarityFunction.DOT_PRODUCT);
                }

                @Override
                public Selector using(SimilarityFunction similarityFunction) {
                    return FunctionCall.from("similarity_" + similarityFunction.name().toLowerCase(Locale.ROOT), this.this$0.columnName, vector).as(this.this$0.columnName);
                }
            };
        }
    }

    public static interface SimilarityBuilder {
        public Selector cosine();

        public Selector euclidean();

        public Selector dotProduct();

        public Selector using(SimilarityFunction var1);
    }

    public static interface SelectorBuilder {
        public Selector column();

        public Selector ttl();

        public SimilarityBuilder similarity(CqlVector<?> var1);

        public SimilarityBuilder similarity(Vector var1);
    }
}

