/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.cassandra.config.KeyspaceActions;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.config.SchemaUtils;
import org.springframework.data.cassandra.config.SessionBuilderConfigurer;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.CassandraPersistentEntitySchemaCreator;
import org.springframework.data.cassandra.core.CassandraPersistentEntitySchemaDropper;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.CassandraExceptionTranslator;
import org.springframework.data.cassandra.core.cql.generator.AlterKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.DropKeyspaceCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.AlterKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.DropKeyspaceSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceActionSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOptionsSpecification;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class CqlSessionFactoryBean
implements FactoryBean<CqlSession>,
InitializingBean,
DisposableBean,
PersistenceExceptionTranslator {
    public static final String CASSANDRA_SYSTEM_SESSION = "system";
    public static final String DEFAULT_CONTACT_POINTS = "localhost";
    public static final int DEFAULT_PORT = 9042;
    private static final boolean DEFAULT_CREATE_IF_NOT_EXISTS = false;
    private static final boolean DEFAULT_DROP_TABLES = false;
    private static final boolean DEFAULT_DROP_UNUSED_TABLES = false;
    private static final CassandraExceptionTranslator EXCEPTION_TRANSLATOR = new CassandraExceptionTranslator();
    protected final Log log = LogFactory.getLog(this.getClass());
    private int port = 9042;
    private @Nullable CassandraConverter converter;
    private @Nullable CqlSession session;
    private @Nullable CqlSession systemSession;
    private List<KeyspaceActions> keyspaceActions = new ArrayList<KeyspaceActions>();
    private List<AlterKeyspaceSpecification> keyspaceAlterations = new ArrayList<AlterKeyspaceSpecification>();
    private List<CreateKeyspaceSpecification> keyspaceCreations = new ArrayList<CreateKeyspaceSpecification>();
    private List<DropKeyspaceSpecification> keyspaceDrops = new ArrayList<DropKeyspaceSpecification>();
    private List<String> keyspaceStartupScripts = new ArrayList<String>();
    private List<String> keyspaceShutdownScripts = new ArrayList<String>();
    private List<String> startupScripts = Collections.emptyList();
    private List<String> shutdownScripts = Collections.emptyList();
    private Set<KeyspaceActionSpecification> keyspaceSpecifications = new HashSet<KeyspaceActionSpecification>();
    private SchemaAction schemaAction = SchemaAction.NONE;
    private boolean suspendLifecycleSchemaRefresh = false;
    private @Nullable SessionBuilderConfigurer sessionBuilderConfigurer;
    private IntFunction<Collection<InetSocketAddress>> contactPoints = port -> CqlSessionFactoryBean.createInetSocketAddresses(DEFAULT_CONTACT_POINTS, port);
    private @Nullable String keyspaceName;
    private @Nullable String localDatacenter;
    private @Nullable String password;
    private @Nullable String username;

    public boolean isConnected() {
        CqlSession session = this.getObject();
        return session != null && !session.isClosed();
    }

    public void setContactPoints(String contactPoints) {
        Assert.hasText((String)contactPoints, (String)"Contact points must not be empty");
        this.contactPoints = port -> CqlSessionFactoryBean.createInetSocketAddresses(contactPoints, port);
    }

    public void setContactPoints(Collection<InetSocketAddress> contactPoints) {
        Assert.notNull(contactPoints, (String)"Contact points must not be null");
        this.contactPoints = unusedPort -> contactPoints;
    }

    public void setLocalDatacenter(@Nullable String localDatacenter) {
        this.localDatacenter = localDatacenter;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Deprecated
    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
    }

    public @Nullable CassandraConverter getConverter() {
        return this.converter;
    }

    public void setKeyspaceActions(List<KeyspaceActions> keyspaceActions) {
        this.keyspaceActions = new ArrayList<KeyspaceActions>(keyspaceActions);
    }

    public List<KeyspaceActions> getKeyspaceActions() {
        return Collections.unmodifiableList(this.keyspaceActions);
    }

    public void setKeyspaceAlterations(List<AlterKeyspaceSpecification> specifications) {
        this.keyspaceAlterations = new ArrayList<AlterKeyspaceSpecification>(specifications);
    }

    public void setKeyspaceCreations(List<CreateKeyspaceSpecification> specifications) {
        this.keyspaceCreations = new ArrayList<CreateKeyspaceSpecification>(specifications);
    }

    public void setKeyspaceDrops(List<DropKeyspaceSpecification> specifications) {
        this.keyspaceDrops = new ArrayList<DropKeyspaceSpecification>(specifications);
    }

    public void setKeyspaceName(@Nullable String keyspaceName) {
        this.keyspaceName = keyspaceName;
    }

    protected @Nullable String getKeyspaceName() {
        return this.keyspaceName;
    }

    public void setKeyspaceSpecifications(List<? extends KeyspaceActionSpecification> keyspaceSpecifications) {
        this.keyspaceSpecifications = new LinkedHashSet<KeyspaceActionSpecification>(keyspaceSpecifications);
    }

    public Set<KeyspaceActionSpecification> getKeyspaceSpecifications() {
        return Collections.unmodifiableSet(this.keyspaceSpecifications);
    }

    public void setKeyspaceStartupScripts(List<String> scripts) {
        this.keyspaceStartupScripts = new ArrayList<String>(scripts);
    }

    public void setKeyspaceShutdownScripts(List<String> scripts) {
        this.keyspaceShutdownScripts = new ArrayList<String>(scripts);
    }

    protected CassandraMappingContext getMappingContext() {
        CassandraConverter converter = this.getConverter();
        Assert.state((converter != null ? 1 : 0) != 0, (String)"CassandraConverter was not properly initialized");
        return converter.getMappingContext();
    }

    @Deprecated
    public void setSchemaAction(SchemaAction schemaAction) {
        Assert.notNull((Object)((Object)schemaAction), (String)"SchemaAction must not be null");
        this.schemaAction = schemaAction;
    }

    public SchemaAction getSchemaAction() {
        return this.schemaAction;
    }

    public void setSuspendLifecycleSchemaRefresh(boolean suspendLifecycleSchemaRefresh) {
        this.suspendLifecycleSchemaRefresh = suspendLifecycleSchemaRefresh;
    }

    protected CqlSession getSession() {
        CqlSession session = this.getObject();
        Assert.state((session != null ? 1 : 0) != 0, (String)"Session was not properly initialized");
        return session;
    }

    public void setSessionBuilderConfigurer(@Nullable SessionBuilderConfigurer sessionBuilderConfigurer) {
        this.sessionBuilderConfigurer = sessionBuilderConfigurer;
    }

    @Deprecated
    public void setStartupScripts(@Nullable List<String> scripts) {
        this.startupScripts = scripts != null ? new ArrayList<String>(scripts) : Collections.emptyList();
    }

    @Deprecated
    public List<String> getStartupScripts() {
        return Collections.unmodifiableList(this.startupScripts);
    }

    @Deprecated
    public void setShutdownScripts(@Nullable List<String> scripts) {
        this.shutdownScripts = scripts != null ? new ArrayList<String>(scripts) : Collections.emptyList();
    }

    @Deprecated
    public List<String> getShutdownScripts() {
        return Collections.unmodifiableList(this.shutdownScripts);
    }

    public void afterPropertiesSet() {
        CqlSessionBuilder sessionBuilder = this.buildBuilder();
        this.systemSession = this.buildSystemSession(sessionBuilder);
        this.initializeCluster(this.systemSession);
        this.session = this.buildSession(sessionBuilder);
        this.initializeSchema(this.systemSession, this.session);
    }

    private void initializeSchema(CqlSession systemSession, CqlSession session) {
        Runnable schemaActionRunnable = () -> {
            this.executeCql(this.getStartupScripts().stream(), session);
            this.performSchemaAction();
        };
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(2);
        if (this.suspendLifecycleSchemaRefresh) {
            futures.add(SchemaUtils.withSuspendedAsyncSchemaRefresh((Session)session, schemaActionRunnable));
        } else {
            futures.add(SchemaUtils.withAsyncSchemaRefresh((Session)session, schemaActionRunnable));
        }
        if (systemSession.isSchemaMetadataEnabled()) {
            futures.add(systemSession.refreshSchemaAsync());
        }
        futures.forEach(CompletableFutures::getUninterruptibly);
    }

    protected CqlSessionBuilder buildBuilder() {
        Collection<InetSocketAddress> addresses = this.contactPoints.apply(this.port);
        Assert.notEmpty(addresses, (String)"At least one server is required");
        CqlSessionBuilder sessionBuilder = this.createBuilder();
        addresses.forEach(arg_0 -> ((CqlSessionBuilder)sessionBuilder).addContactPoint(arg_0));
        if (StringUtils.hasText((String)this.username)) {
            sessionBuilder.withAuthCredentials(this.username, this.password);
        }
        if (StringUtils.hasText((String)this.localDatacenter)) {
            sessionBuilder.withLocalDatacenter(this.localDatacenter);
        }
        return this.sessionBuilderConfigurer != null ? this.sessionBuilderConfigurer.configure(sessionBuilder) : sessionBuilder;
    }

    CqlSessionBuilder createBuilder() {
        return CqlSession.builder();
    }

    protected CqlSession buildSystemSession(CqlSessionBuilder sessionBuilder) {
        return (CqlSession)((CqlSessionBuilder)sessionBuilder.withKeyspace(CASSANDRA_SYSTEM_SESSION)).build();
    }

    protected CqlSession buildSession(CqlSessionBuilder sessionBuilder) {
        if (StringUtils.hasText((String)this.getKeyspaceName())) {
            sessionBuilder.withKeyspace(this.getKeyspaceName());
        }
        return (CqlSession)sessionBuilder.build();
    }

    private void initializeCluster(CqlSession session) {
        this.generateSpecificationsFromFactoryBeanDeclarations();
        ArrayList<KeyspaceOptionsSpecification> keyspaceStartupSpecifications = new ArrayList<KeyspaceOptionsSpecification>(this.keyspaceCreations.size() + this.keyspaceAlterations.size());
        keyspaceStartupSpecifications.addAll(this.keyspaceCreations);
        keyspaceStartupSpecifications.addAll(this.keyspaceAlterations);
        Runnable schemaActionRunnable = () -> this.executeSpecificationsAndScripts(keyspaceStartupSpecifications, this.keyspaceStartupScripts, session);
        if (this.suspendLifecycleSchemaRefresh) {
            SchemaUtils.withSuspendedAsyncSchemaRefresh((Session)session, schemaActionRunnable);
        } else {
            schemaActionRunnable.run();
        }
    }

    private void generateSpecificationsFromFactoryBeanDeclarations() {
        this.generateSpecifications(this.keyspaceSpecifications);
        this.keyspaceActions.forEach(actions -> this.generateSpecifications(actions.getActions()));
    }

    private void generateSpecifications(Collection<KeyspaceActionSpecification> specifications) {
        specifications.forEach(specification -> {
            if (specification instanceof AlterKeyspaceSpecification) {
                this.keyspaceAlterations.add((AlterKeyspaceSpecification)specification);
            } else if (specification instanceof CreateKeyspaceSpecification) {
                this.keyspaceCreations.add((CreateKeyspaceSpecification)specification);
            } else if (specification instanceof DropKeyspaceSpecification) {
                this.keyspaceDrops.add((DropKeyspaceSpecification)specification);
            }
        });
    }

    protected void performSchemaAction() {
        boolean create = false;
        boolean drop = false;
        boolean dropUnused = false;
        boolean ifNotExists = false;
        switch (this.schemaAction) {
            case RECREATE_DROP_UNUSED: {
                dropUnused = true;
            }
            case RECREATE: {
                drop = true;
            }
            case CREATE_IF_NOT_EXISTS: {
                ifNotExists = SchemaAction.CREATE_IF_NOT_EXISTS.equals((Object)this.schemaAction);
            }
            case CREATE: {
                create = true;
            }
        }
        if (create) {
            this.createTables(drop, dropUnused, ifNotExists);
        }
    }

    protected void createTables(boolean drop, boolean dropUnused, boolean ifNotExists) {
        Assert.state((this.session != null ? 1 : 0) != 0, (String)"CqlSession must be initialized");
        Assert.state((this.converter != null ? 1 : 0) != 0, (String)"CassandraConverter must be initialized");
        CassandraAdminTemplate adminTemplate = new CassandraAdminTemplate(this.session, this.converter);
        this.performSchemaActions(drop, dropUnused, ifNotExists, adminTemplate);
    }

    private void performSchemaActions(boolean drop, boolean dropUnused, boolean ifNotExists, CassandraAdminOperations adminOperations) {
        CassandraPersistentEntitySchemaCreator schemaCreator = new CassandraPersistentEntitySchemaCreator(this.getMappingContext(), adminOperations);
        if (drop) {
            CassandraPersistentEntitySchemaDropper schemaDropper = new CassandraPersistentEntitySchemaDropper(this.getMappingContext(), adminOperations);
            schemaDropper.dropTables(dropUnused);
            schemaDropper.dropUserTypes(dropUnused);
        }
        schemaCreator.createUserTypes(ifNotExists);
        schemaCreator.createTables(ifNotExists);
        schemaCreator.createIndexes(ifNotExists);
    }

    public @Nullable CqlSession getObject() {
        return this.session;
    }

    public Class<? extends CqlSession> getObjectType() {
        return CqlSession.class;
    }

    public @Nullable DataAccessException translateExceptionIfPossible(RuntimeException e) {
        return EXCEPTION_TRANSLATOR.translateExceptionIfPossible(e);
    }

    public void destroy() {
        if (this.session != null) {
            Runnable schemaActionRunnable = () -> this.executeCql(this.getShutdownScripts().stream(), this.session);
            Runnable systemSchemaActionRunnable = () -> {
                if (this.systemSession != null) {
                    this.executeSpecificationsAndScripts(this.keyspaceDrops, this.keyspaceShutdownScripts, this.systemSession);
                }
            };
            if (this.suspendLifecycleSchemaRefresh) {
                SchemaUtils.withSuspendedAsyncSchemaRefresh((Session)this.session, schemaActionRunnable);
                if (this.systemSession != null) {
                    SchemaUtils.withSuspendedAsyncSchemaRefresh((Session)this.systemSession, systemSchemaActionRunnable);
                }
            } else {
                schemaActionRunnable.run();
                systemSchemaActionRunnable.run();
            }
            this.closeSession();
            this.closeSystemSession();
        }
    }

    protected void closeSession() {
        if (this.session != null) {
            this.session.close();
        }
    }

    protected void closeSystemSession() {
        if (this.systemSession != null) {
            this.systemSession.close();
        }
    }

    private void executeCql(Stream<String> cql, CqlSession session) {
        cql.forEach(query2 -> {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)String.format("Executing CQL [%s]", query2));
            }
            session.execute(query2);
        });
    }

    private void executeSpecificationsAndScripts(List<? extends KeyspaceActionSpecification> keyspaceActionSpecifications, List<String> keyspaceCqlScripts, CqlSession session) {
        if (!CollectionUtils.isEmpty(keyspaceActionSpecifications) || !CollectionUtils.isEmpty(keyspaceCqlScripts)) {
            Stream<String> keyspaceActionSpecificationsStream = keyspaceActionSpecifications.stream().map(CqlSessionFactoryBean::toCql);
            Stream keyspaceCqlScriptsStream = keyspaceCqlScripts.stream();
            Stream<String> cql = Stream.concat(keyspaceActionSpecificationsStream, keyspaceCqlScriptsStream);
            this.executeCql(cql, session);
        }
    }

    private static String toCql(KeyspaceActionSpecification specification) {
        if (specification instanceof AlterKeyspaceSpecification) {
            return new AlterKeyspaceCqlGenerator((AlterKeyspaceSpecification)specification).toCql();
        }
        if (specification instanceof CreateKeyspaceSpecification) {
            return new CreateKeyspaceCqlGenerator((CreateKeyspaceSpecification)specification).toCql();
        }
        if (specification instanceof DropKeyspaceSpecification) {
            return new DropKeyspaceCqlGenerator((DropKeyspaceSpecification)specification).toCql();
        }
        throw new IllegalArgumentException(String.format("Unsupported specification type: %s", ClassUtils.getQualifiedName(specification.getClass())));
    }

    private static Collection<InetSocketAddress> createInetSocketAddresses(String contactPoints, int defaultPort) {
        return StringUtils.commaDelimitedListToSet((String)contactPoints).stream().map(contactPoint -> HostAndPort.createWithDefaultPort(contactPoint, defaultPort)).map(hostAndPort -> InetSocketAddress.createUnresolved(hostAndPort.getHost(), hostAndPort.getPort())).collect(Collectors.toList());
    }

    private static class HostAndPort {
        private final String host;
        private final int port;

        private HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        static HostAndPort createWithDefaultPort(String contactPoint, int defaultPort) {
            String host;
            int i = contactPoint.lastIndexOf(58);
            if (i == -1 || !HostAndPort.isValidPort(contactPoint.substring(i + 1))) {
                return new HostAndPort(contactPoint, defaultPort);
            }
            String[] hostAndPort = contactPoint.split(":");
            int port = defaultPort;
            if (hostAndPort.length != 2) {
                int bracketEnd = contactPoint.indexOf(93);
                if (contactPoint.startsWith("[") && bracketEnd != -1) {
                    host = contactPoint.substring(0, bracketEnd + 1);
                    String remainder = contactPoint.substring(bracketEnd + 1);
                    if (remainder.startsWith(":")) {
                        port = Integer.parseInt(remainder.substring(1));
                    }
                } else {
                    host = contactPoint;
                }
            } else {
                host = hostAndPort[0];
                port = Integer.parseInt(hostAndPort[1]);
            }
            return new HostAndPort(host, port);
        }

        private static boolean isValidPort(String value) {
            try {
                int i = Integer.parseInt(value);
                return i > 0 && i < 65535;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }
    }
}

