/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.util.List;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.data.cassandra.core.EntityQueryUtils;
import org.springframework.data.cassandra.core.QueryResultConverter;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.ReactiveSelectOperation;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;

class ReactiveSelectOperationSupport
implements ReactiveSelectOperation {
    private final ReactiveCassandraTemplate template;

    public ReactiveSelectOperationSupport(ReactiveCassandraTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveSelectOperation.ReactiveSelect<T> query(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ReactiveSelectSupport(this.template, domainType, domainType, QueryResultConverter.entity(), Query.empty(), null);
    }

    @Override
    public ReactiveSelectOperation.UntypedSelect query(String cql) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return new UntypedSelectSupport(this.template, (Statement<?>)SimpleStatement.newInstance((String)cql));
    }

    @Override
    public ReactiveSelectOperation.UntypedSelect query(Statement<?> statement) {
        Assert.notNull(statement, (String)"Statement must not be null");
        return new UntypedSelectSupport(this.template, statement);
    }

    private static <T> void handleOne(List<T> objects, SynchronousSink<T> sink, Supplier<@Nullable String> query2) {
        if (objects.isEmpty()) {
            return;
        }
        if (objects.size() == 1) {
            sink.next(objects.get(0));
            return;
        }
        sink.error((Throwable)new IncorrectResultSizeDataAccessException(String.format("Query [%s] returned non unique result", query2.get()), 1));
    }

    static class ReactiveSelectSupport<S, T>
    implements ReactiveSelectOperation.ReactiveSelect<T> {
        private final ReactiveCassandraTemplate template;
        private final Class<?> domainType;
        private final Class<S> returnType;
        private final QueryResultConverter<? super S, ? extends T> mappingFunction;
        private final Query query;
        private final @Nullable CqlIdentifier tableName;

        public ReactiveSelectSupport(ReactiveCassandraTemplate template, Class<?> domainType, Class<S> returnType, QueryResultConverter<? super S, ? extends T> mappingFunction, Query query2, @Nullable CqlIdentifier tableName) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.mappingFunction = mappingFunction;
            this.query = query2;
            this.tableName = tableName;
        }

        @Override
        public <R> ReactiveSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            Assert.notNull(converter, (String)"Mapping function name must not be null");
            return new ReactiveSelectSupport<S, R>(this.template, this.domainType, this.returnType, this.mappingFunction.andThen(converter), this.query, this.tableName);
        }

        @Override
        public ReactiveSelectOperation.SelectWithProjection<T> inTable(CqlIdentifier tableName) {
            Assert.notNull((Object)tableName, (String)"Table name must not be null");
            return new ReactiveSelectSupport<S, T>(this.template, this.domainType, this.returnType, this.mappingFunction, this.query, tableName);
        }

        @Override
        public <R> ReactiveSelectOperation.SelectWithQuery<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null");
            return new ReactiveSelectSupport(this.template, this.domainType, returnType, QueryResultConverter.entity(), this.query, this.tableName);
        }

        @Override
        public ReactiveSelectOperation.TerminatingSelect<T> matching(Query query2) {
            Assert.notNull((Object)query2, (String)"Query must not be null");
            return new ReactiveSelectSupport<S, T>(this.template, this.domainType, this.returnType, this.mappingFunction, query2, this.tableName);
        }

        @Override
        public Mono<Long> count() {
            return this.template.doCount(this.query, this.domainType, this.getTableName());
        }

        @Override
        public Mono<Boolean> exists() {
            return this.template.doExists(this.query, this.domainType, this.getTableName());
        }

        @Override
        public Mono<T> first() {
            Flux<? extends T> one = this.template.doSelect(this.query.limit(1L), this.domainType, this.getTableName(), this.returnType, this.mappingFunction);
            return one.next();
        }

        @Override
        public Mono<T> one() {
            Flux<? extends T> result = this.template.doSelect(this.query.limit(2L), this.domainType, this.getTableName(), this.returnType, this.mappingFunction);
            return result.collectList().handle((objects, sink) -> ReactiveSelectOperationSupport.handleOne(objects, sink, this.query::toString));
        }

        @Override
        public Flux<T> all() {
            return this.template.doSelect(this.query, this.domainType, this.getTableName(), this.returnType, this.mappingFunction);
        }

        private CqlIdentifier getTableName() {
            return this.tableName != null ? this.tableName : this.template.getTableName(this.domainType);
        }
    }

    private record UntypedSelectSupport(ReactiveCassandraTemplate template, Statement<?> statement) implements ReactiveSelectOperation.UntypedSelect
    {
        @Override
        public <T> ReactiveSelectOperation.TerminatingResults<T> as(Class<T> resultType) {
            Assert.notNull(resultType, (String)"Result type must not be null");
            return new TypedSelectSupport<T>(this.template, this.statement, resultType);
        }

        @Override
        public <T> ReactiveSelectOperation.TerminatingResults<T> map(RowMapper<T> mapper) {
            Assert.notNull(mapper, (String)"RowMapper must not be null");
            return new TerminatingSelectResultSupport(this.template, this.statement, mapper);
        }
    }

    static class TerminatingSelectResultSupport<S, T>
    implements ReactiveSelectOperation.TerminatingResults<T> {
        final ReactiveCassandraTemplate template;
        final Statement<?> statement;
        final RowMapper<T> rowMapper;

        TerminatingSelectResultSupport(ReactiveCassandraTemplate template, Statement<?> statement, RowMapper<T> rowMapper) {
            this.template = template;
            this.statement = statement;
            this.rowMapper = rowMapper;
        }

        TerminatingSelectResultSupport(ReactiveCassandraTemplate template, Statement<?> statement, Class<S> domainType, QueryResultConverter<? super S, ? extends T> mappingFunction) {
            this(template, statement, template.getRowMapper(domainType, EntityQueryUtils.getTableName(statement), mappingFunction));
        }

        @Override
        public <R> ReactiveSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            return new TerminatingSelectResultSupport<S, Object>(this.template, this.statement, (row, rowNum) -> converter.mapRow(row, () -> this.rowMapper.mapRow(row, rowNum)));
        }

        @Override
        public Mono<T> first() {
            return this.template.getReactiveCqlOperations().query(this.statement, this.rowMapper).next();
        }

        @Override
        public Mono<T> one() {
            Flux<T> result = this.template.getReactiveCqlOperations().query(this.statement, this.rowMapper);
            return result.collectList().handle((objects, sink) -> ReactiveSelectOperationSupport.handleOne(objects, sink, () -> QueryExtractorDelegate.getCql(this.statement)));
        }

        @Override
        public Flux<T> all() {
            return this.template.getReactiveCqlOperations().query(this.statement, this.rowMapper);
        }
    }

    static class TypedSelectSupport<T>
    extends TerminatingSelectResultSupport<T, T>
    implements ReactiveSelectOperation.TerminatingResults<T> {
        private final Class<T> domainType;

        TypedSelectSupport(ReactiveCassandraTemplate template, Statement<?> statement, Class<T> domainType) {
            super(template, statement, template.getRowMapper(domainType, EntityQueryUtils.getTableName(statement), QueryResultConverter.entity()));
            this.domainType = domainType;
        }

        @Override
        public <R> ReactiveSelectOperation.TerminatingResults<R> map(QueryResultConverter<? super T, ? extends R> converter) {
            Assert.notNull(converter, (String)"Mapping function must not be null");
            return new TerminatingSelectResultSupport<T, R>(this.template, this.statement, this.domainType, converter);
        }
    }
}

