/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.BatchType;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.truncate.Truncate;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.CassandraBatchOperations;
import org.springframework.data.cassandra.core.CassandraBatchTemplate;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.core.EntityLifecycleEventDelegate;
import org.springframework.data.cassandra.core.EntityOperations;
import org.springframework.data.cassandra.core.EntityQueryUtils;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.ExecutableDeleteOperation;
import org.springframework.data.cassandra.core.ExecutableDeleteOperationSupport;
import org.springframework.data.cassandra.core.ExecutableInsertOperation;
import org.springframework.data.cassandra.core.ExecutableInsertOperationSupport;
import org.springframework.data.cassandra.core.ExecutableSelectOperation;
import org.springframework.data.cassandra.core.ExecutableSelectOperationSupport;
import org.springframework.data.cassandra.core.ExecutableUpdateOperation;
import org.springframework.data.cassandra.core.ExecutableUpdateOperationSupport;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.PreparedStatementDelegate;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlOperations;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.CqlTemplate;
import org.springframework.data.cassandra.core.cql.PreparedStatementBinder;
import org.springframework.data.cassandra.core.cql.PreparedStatementCreator;
import org.springframework.data.cassandra.core.cql.QueryExtractorDelegate;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.cql.SessionCallback;
import org.springframework.data.cassandra.core.cql.SingleColumnRowMapper;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.cql.util.StatementBuilder;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.SimpleUserTypeResolver;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeConvertCallback;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveCallback;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.CassandraMappingEvent;
import org.springframework.data.cassandra.core.query.Columns;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.util.Assert;

public class CassandraTemplate
implements CassandraOperations,
ApplicationEventPublisherAware,
ApplicationContextAware {
    private final Log log = LogFactory.getLog(this.getClass());
    private final CqlOperations cqlOperations;
    private final CassandraConverter converter;
    private final EntityOperations entityOperations;
    private final StatementFactory statementFactory;
    private final EntityLifecycleEventDelegate eventDelegate;
    private @Nullable EntityCallbacks entityCallbacks;
    private boolean usePreparedStatements = true;

    public CassandraTemplate(CqlSession session) {
        this(session, (CassandraConverter)CassandraTemplate.newConverter(session));
    }

    public CassandraTemplate(CqlSession session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public CassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new CqlTemplate(sessionFactory), converter);
    }

    public CassandraTemplate(CqlOperations cqlOperations, CassandraConverter converter) {
        Assert.notNull((Object)cqlOperations, (String)"CqlOperations must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.cqlOperations = cqlOperations;
        this.entityOperations = new EntityOperations(converter);
        this.statementFactory = new StatementFactory(converter);
        this.eventDelegate = new EntityLifecycleEventDelegate();
    }

    @Override
    public CassandraBatchOperations batchOps(BatchType batchType) {
        return new CassandraBatchTemplate(this, batchType);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventDelegate.setPublisher(applicationEventPublisher);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(@Nullable EntityCallbacks entityCallbacks) {
        this.entityCallbacks = entityCallbacks;
    }

    public void setEntityLifecycleEventsEnabled(boolean enabled) {
        this.eventDelegate.setEventsEnabled(enabled);
    }

    @Override
    public CqlOperations getCqlOperations() {
        return this.cqlOperations;
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    public StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    public boolean isUsePreparedStatements() {
        return this.usePreparedStatements;
    }

    public void setUsePreparedStatements(boolean usePreparedStatements) {
        this.usePreparedStatements = usePreparedStatements;
    }

    protected EntityOperations getEntityOperations() {
        return this.entityOperations;
    }

    protected SpelAwareProxyProjectionFactory getProjectionFactory() {
        return (SpelAwareProxyProjectionFactory)this.getConverter().getProjectionFactory();
    }

    private CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityType) {
        return this.getEntityOperations().getRequiredPersistentEntity(entityType);
    }

    @Override
    public CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getEntityOperations().getTableName(entityClass);
    }

    @Override
    public <T> List<T> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        return this.select((Statement<?>)SimpleStatement.newInstance((String)cql), entityClass);
    }

    @Override
    public <T> @Nullable T selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement<?>)SimpleStatement.newInstance((String)cql), entityClass);
    }

    @Override
    public <T> Stream<T> stream(String cql, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"CQL must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.stream((Statement<?>)SimpleStatement.newInstance((String)cql), entityClass);
    }

    @Override
    public ResultSet execute(Statement<?> statement) {
        Assert.notNull(statement, (String)"Statement must not be null");
        return this.doQueryForResultSet(statement);
    }

    @Override
    public <T> List<T> select(Statement<?> statement, Class<T> entityClass) {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(EntityProjection.nonProjecting(entityClass), EntityQueryUtils.getTableName(statement));
        return this.doQuery(statement, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> @Nullable T selectOne(Statement<?> statement, Class<T> entityClass) {
        List<T> result = this.select(statement, entityClass);
        return result.isEmpty() ? null : (T)result.get(0);
    }

    @Override
    public <T> Slice<T> slice(Statement<?> statement, Class<T> entityClass) {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ResultSet resultSet = this.doQueryForResultSet(statement);
        Function mapper = this.getMapper(EntityProjection.nonProjecting(entityClass), EntityQueryUtils.getTableName(statement));
        return EntityQueryUtils.readSlice(resultSet, (row, rowNum) -> mapper.apply(row), 0, this.getEffectivePageSize(statement));
    }

    @Override
    public <T> Stream<T> stream(Statement<?> statement, Class<T> entityClass) throws DataAccessException {
        Assert.notNull(statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Function mapper = this.getMapper(EntityProjection.nonProjecting(entityClass), EntityQueryUtils.getTableName(statement));
        return this.doQueryForStream(statement, (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> List<T> select(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doSelect(query2, entityClass, this.getTableName(entityClass), entityClass);
    }

    <T> List<T> doSelect(Query query2, Class<?> entityClass, CqlIdentifier tableName, Class<T> returnType) {
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        EntityProjection<T, ?> projection = this.entityOperations.introspectProjection(returnType, entityClass);
        Columns columns = this.getStatementFactory().computeColumnsForProjection(projection, query2.getColumns(), entity, returnType);
        Query queryToUse = query2.columns(columns);
        StatementBuilder<Select> select2 = this.getStatementFactory().select(queryToUse, entity, tableName);
        Function mapper = this.getMapper(projection, tableName);
        return this.doQuery((Statement<?>)select2.build(), (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public <T> @Nullable T selectOne(Query query2, Class<T> entityClass) throws DataAccessException {
        List<T> result = this.select(query2, entityClass);
        return result.isEmpty() ? null : (T)result.get(0);
    }

    @Override
    public <T> Slice<T> slice(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        StatementBuilder<Select> select2 = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass));
        return this.slice((Statement<?>)select2.build(), entityClass);
    }

    @Override
    public <T> Stream<T> stream(Query query2, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doStream(query2, entityClass, this.getTableName(entityClass), entityClass);
    }

    <T> Stream<T> doStream(Query query2, Class<?> entityClass, CqlIdentifier tableName, Class<T> returnType) {
        StatementBuilder<Select> select2 = this.getStatementFactory().select(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        EntityProjection<T, ?> projection = this.entityOperations.introspectProjection(returnType, entityClass);
        Function mapper = this.getMapper(projection, tableName);
        return this.doQueryForStream((Statement<?>)select2.build(), (row, rowNum) -> mapper.apply(row));
    }

    @Override
    public boolean update(Query query2, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> updateStatement = this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass));
        return this.doExecute(updateStatement.build()).wasApplied();
    }

    WriteResult doUpdate(Query query2, Update update, Class<?> entityClass, CqlIdentifier tableName) {
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> updateStatement = this.getStatementFactory().update(query2, update, this.getRequiredPersistentEntity(entityClass), tableName);
        return this.doExecute(updateStatement.build());
    }

    @Override
    public boolean delete(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        WriteResult result = this.doDelete(query2, entityClass, this.getTableName(entityClass));
        return result != null && result.wasApplied();
    }

    WriteResult doDelete(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        StatementBuilder<Delete> delete = this.getStatementFactory().delete(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        SimpleStatement statement = delete.build();
        this.maybeEmitEvent(() -> new BeforeDeleteEvent((Statement<?>)statement, entityClass, tableName));
        WriteResult writeResult = this.doExecute(statement);
        this.maybeEmitEvent(() -> new AfterDeleteEvent((Statement<?>)statement, entityClass, tableName));
        return writeResult;
    }

    @Override
    public long count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.count(Query.empty(), entityClass);
    }

    @Override
    public long count(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doCount(query2, entityClass, this.getTableName(entityClass));
    }

    long doCount(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        StatementBuilder<Select> countStatement = this.getStatementFactory().count(query2, this.getRequiredPersistentEntity(entityClass), tableName);
        return this.doQueryForRequiredObject((Statement<?>)countStatement.build(), (Class)Long.class);
    }

    @Override
    public boolean exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        StatementBuilder<Select> select2 = this.getStatementFactory().selectOneById(id, entity, entity.getTableName());
        return this.doQueryForResultSet((Statement<?>)select2.build()).one() != null;
    }

    @Override
    public boolean exists(Query query2, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query2, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.doExists(query2, entityClass, this.getTableName(entityClass));
    }

    boolean doExists(Query query2, Class<?> entityClass, CqlIdentifier tableName) {
        StatementBuilder<Select> select2 = this.getStatementFactory().select(query2.limit(1L), this.getRequiredPersistentEntity(entityClass), tableName);
        return this.doQueryForResultSet((Statement<?>)select2.build()).one() != null;
    }

    @Override
    public <T> @Nullable T selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        StatementBuilder<Select> select2 = this.getStatementFactory().selectOneById(id, entity, tableName);
        Function mapper = this.getMapper(EntityProjection.nonProjecting(entityClass), tableName);
        List<Object> result = this.doQuery((Statement<?>)select2.build(), (row, rowNum) -> mapper.apply(row));
        return (T)(result.isEmpty() ? null : result.get(0));
    }

    @Override
    public <T> T insert(T entity) {
        return this.insert(entity, InsertOptions.empty()).getEntity();
    }

    @Override
    public <T> EntityWriteResult<T> insert(T entity, InsertOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        return this.doInsert(entity, options, this.getTableName(entity.getClass()));
    }

    <T> EntityWriteResult<T> doInsert(T entity, WriteOptions options, CqlIdentifier tableName) {
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(this.maybeCallBeforeConvert(entity, tableName), this.getConverter().getConversionService());
        T entityToUse = source.isVersionedEntity() ? source.initializeVersionProperty() : source.getBean();
        StatementBuilder<RegularInsert> builder = this.getStatementFactory().insert(entityToUse, options, source.getPersistentEntity(), tableName);
        if (source.isVersionedEntity()) {
            builder.apply(Insert::ifNotExists);
            return this.doInsertVersioned(builder.build(), entityToUse, source, tableName);
        }
        return this.doInsert(builder.build(), entityToUse, tableName);
    }

    private <T> EntityWriteResult<T> doInsertVersioned(SimpleStatement insert, T entity, EntityOperations.AdaptibleEntity<T> source, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, insert, result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot insert entity %s with version %s into table %s as it already exists", entity, source.getVersion(), tableName));
            }
        });
    }

    private <T> EntityWriteResult<T> doInsert(SimpleStatement insert, T entity, CqlIdentifier tableName) {
        return this.executeSave(entity, tableName, insert);
    }

    @Override
    public <T> T update(T entity) {
        return this.update(entity, UpdateOptions.empty()).getEntity();
    }

    @Override
    public <T> EntityWriteResult<T> update(T entity, UpdateOptions options) {
        Assert.notNull(entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        EntityOperations.AdaptibleEntity<T> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        T entityToUpdate = this.maybeCallBeforeConvert(entity, tableName);
        return source.isVersionedEntity() ? this.doUpdateVersioned(entityToUpdate, options, tableName, persistentEntity) : this.doUpdate(entityToUpdate, options, tableName, persistentEntity);
    }

    private <T> EntityWriteResult<T> doUpdateVersioned(T entity, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        EntityOperations.AdaptibleEntity source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        Number previousVersion = source.getVersion();
        Object toSave = source.incrementVersion();
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> builder = this.getStatementFactory().update(toSave, options, persistentEntity, tableName);
        SimpleStatement update = source.appendVersionCondition(builder, previousVersion).build();
        return this.executeSave(toSave, tableName, update, result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot save entity %s with version %s to table %s; Has it been modified meanwhile", toSave, source.getVersion(), tableName));
            }
        });
    }

    private <T> EntityWriteResult<T> doUpdate(T entity, UpdateOptions options, CqlIdentifier tableName, CassandraPersistentEntity<?> persistentEntity) {
        StatementBuilder<com.datastax.oss.driver.api.querybuilder.update.Update> builder = this.getStatementFactory().update(entity, options, persistentEntity, tableName);
        return this.executeSave(entity, tableName, builder.build());
    }

    @Override
    public void delete(Object entity) {
        this.delete(entity, QueryOptions.empty());
    }

    @Override
    public WriteResult delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        EntityOperations.AdaptibleEntity<Object> source = this.getEntityOperations().forEntity(entity, this.getConverter().getConversionService());
        CassandraPersistentEntity<?> persistentEntity = this.getRequiredPersistentEntity(entity.getClass());
        CqlIdentifier tableName = persistentEntity.getTableName();
        StatementBuilder<Delete> builder = this.getStatementFactory().delete(entity, options, (EntityWriter<Object, Object>)this.getConverter(), tableName);
        return source.isVersionedEntity() ? this.doDeleteVersioned(source.appendVersionCondition(builder).build(), entity, source, tableName) : this.doDelete(builder.build(), entity, tableName);
    }

    private WriteResult doDeleteVersioned(SimpleStatement statement, Object entity, EntityOperations.AdaptibleEntity<Object> source, CqlIdentifier tableName) {
        return this.executeDelete(entity, tableName, statement, result -> {
            if (!result.wasApplied()) {
                throw new OptimisticLockingFailureException(String.format("Cannot delete entity %s with version %s in table %s; Has it been modified meanwhile", entity, source.getVersion(), tableName));
            }
        });
    }

    private WriteResult doDelete(SimpleStatement delete, Object entity, CqlIdentifier tableName) {
        return this.executeDelete(entity, tableName, delete, result -> {});
    }

    @Override
    public boolean deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        StatementBuilder<Delete> delete = this.getStatementFactory().deleteById(id, entity, tableName);
        SimpleStatement statement = delete.build();
        this.maybeEmitEvent(() -> new BeforeDeleteEvent((Statement<?>)statement, entityClass, tableName));
        boolean result = this.doExecute(statement).wasApplied();
        this.maybeEmitEvent(() -> new AfterDeleteEvent((Statement<?>)statement, entityClass, tableName));
        return result;
    }

    @Override
    public void truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity<?> entity = this.getRequiredPersistentEntity(entityClass);
        CqlIdentifier tableName = entity.getTableName();
        Truncate truncate = QueryBuilder.truncate((CqlIdentifier)entity.getKeyspace(), (CqlIdentifier)tableName);
        SimpleStatement statement = truncate.build();
        this.maybeEmitEvent(() -> new BeforeDeleteEvent((Statement<?>)statement, entityClass, tableName));
        this.doExecute(statement);
        this.maybeEmitEvent(() -> new AfterDeleteEvent((Statement<?>)statement, entityClass, tableName));
    }

    @Override
    public <T> ExecutableSelectOperation.ExecutableSelect<T> query(Class<T> domainType) {
        return new ExecutableSelectOperationSupport(this).query(domainType);
    }

    @Override
    public <T> ExecutableInsertOperation.ExecutableInsert<T> insert(Class<T> domainType) {
        return new ExecutableInsertOperationSupport(this).insert(domainType);
    }

    @Override
    public ExecutableUpdateOperation.ExecutableUpdate update(Class<?> domainType) {
        return new ExecutableUpdateOperationSupport(this).update(domainType);
    }

    @Override
    public ExecutableDeleteOperation.ExecutableDelete delete(Class<?> domainType) {
        return new ExecutableDeleteOperationSupport(this).delete(domainType);
    }

    protected PreparedStatementHandler createPreparedStatementHandler(Statement<?> statement) {
        return new PreparedStatementHandler(statement);
    }

    private <T> EntityWriteResult<T> executeSave(T entity, CqlIdentifier tableName, SimpleStatement statement) {
        return this.executeSave(entity, tableName, statement, ignore -> {});
    }

    private <T> EntityWriteResult<T> executeSave(T entity, CqlIdentifier tableName, SimpleStatement statement, Consumer<WriteResult> resultConsumer) {
        this.maybeEmitEvent(() -> new BeforeSaveEvent<Object>(entity, tableName, (Statement<?>)statement));
        Object entityToSave = this.maybeCallBeforeSave(entity, tableName, (Statement<?>)statement);
        WriteResult result = this.doExecute(statement);
        resultConsumer.accept(result);
        this.maybeEmitEvent(() -> new AfterSaveEvent<Object>(entityToSave, tableName));
        return EntityWriteResult.of(result, entityToSave);
    }

    private WriteResult executeDelete(Object entity, CqlIdentifier tableName, SimpleStatement statement, Consumer<WriteResult> resultConsumer) {
        this.maybeEmitEvent(() -> new BeforeDeleteEvent((Statement<?>)statement, entity.getClass(), tableName));
        WriteResult result = this.doExecute(statement);
        resultConsumer.accept(result);
        this.maybeEmitEvent(() -> new AfterDeleteEvent((Statement<?>)statement, entity.getClass(), tableName));
        return result;
    }

    private <T> List<T> doQuery(Statement<?> statement, RowMapper<T> rowMapper) {
        if (PreparedStatementDelegate.canPrepare(this.isUsePreparedStatements(), statement, this.log)) {
            PreparedStatementHandler statementHandler = this.createPreparedStatementHandler(statement);
            return this.getCqlOperations().query((PreparedStatementCreator)statementHandler, (PreparedStatementBinder)statementHandler, rowMapper);
        }
        return this.getCqlOperations().query(statement, rowMapper);
    }

    private <T> T doQueryForRequiredObject(Statement<?> statement, Class<T> resultType) {
        return (T)DataAccessUtils.requiredSingleResult(this.doQuery(statement, SingleColumnRowMapper.newInstance(resultType)));
    }

    private <T> Stream<T> doQueryForStream(Statement<?> statement, RowMapper<T> rowMapper) {
        if (PreparedStatementDelegate.canPrepare(this.isUsePreparedStatements(), statement, this.log)) {
            PreparedStatementHandler statementHandler = this.createPreparedStatementHandler(statement);
            return this.getCqlOperations().queryForStream(statementHandler, statementHandler, rowMapper);
        }
        return this.getCqlOperations().queryForStream(statement, rowMapper);
    }

    private WriteResult doExecute(SimpleStatement statement) {
        return this.doExecute((Statement<?>)statement, (Function)WriteResult::of);
    }

    private ResultSet doQueryForResultSet(Statement<?> statement) {
        return (ResultSet)this.doExecute(statement, Function.identity());
    }

    private <T> T doExecute(Statement<?> statement, Function<ResultSet, T> mappingFunction) {
        if (PreparedStatementDelegate.canPrepare(this.isUsePreparedStatements(), statement, this.log)) {
            PreparedStatementHandler statementHandler = this.createPreparedStatementHandler(statement);
            return (T)this.getCqlOperations().query((PreparedStatementCreator)statementHandler, (PreparedStatementBinder)statementHandler, mappingFunction::apply);
        }
        return mappingFunction.apply(this.getCqlOperations().queryForResultSet(statement));
    }

    private int getConfiguredPageSize(CqlSession session) {
        return session.getContext().getConfig().getDefaultProfile().getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, 5000);
    }

    private int getEffectivePageSize(final Statement<?> statement) {
        CassandraAccessor accessor;
        if (statement.getPageSize() > 0) {
            return statement.getPageSize();
        }
        CqlOperations cqlOperations = this.getCqlOperations();
        if (cqlOperations instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)cqlOperations)).getFetchSize() != -1) {
            return accessor.getFetchSize();
        }
        class GetConfiguredPageSize
        implements SessionCallback<Integer>,
        CqlProvider {
            GetConfiguredPageSize() {
            }

            @Override
            public Integer doInSession(CqlSession session) {
                return CassandraTemplate.this.getConfiguredPageSize(session);
            }

            @Override
            public String getCql() {
                return QueryExtractorDelegate.getCql(statement);
            }
        }
        return this.getCqlOperations().execute(new GetConfiguredPageSize());
    }

    private <T> Function<Row, T> getMapper(EntityProjection<T, ?> projection, CqlIdentifier tableName) {
        Class targetType = projection.getMappedType().getType();
        return row -> {
            this.maybeEmitEvent(() -> new AfterLoadEvent((Row)row, targetType, tableName));
            Object result = this.getConverter().project(projection, (Row)row);
            this.maybeEmitEvent(() -> new AfterConvertEvent<Object>((Row)row, result, tableName));
            return result;
        };
    }

    private static MappingCassandraConverter newConverter(CqlSession session) {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.setUserTypeResolver(new SimpleUserTypeResolver(session));
        converter.setCodecRegistry(session.getContext().getCodecRegistry());
        converter.afterPropertiesSet();
        return converter;
    }

    protected <E extends CassandraMappingEvent<T>, T> void maybeEmitEvent(Supplier<E> event) {
        this.eventDelegate.publishEvent(event);
    }

    protected <T> T maybeCallBeforeConvert(T object, CqlIdentifier tableName) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(BeforeConvertCallback.class, object, new Object[]{tableName});
        }
        return object;
    }

    protected <T> T maybeCallBeforeSave(T object, CqlIdentifier tableName, Statement<?> statement) {
        if (null != this.entityCallbacks) {
            return (T)this.entityCallbacks.callback(BeforeSaveCallback.class, object, new Object[]{tableName, statement});
        }
        return object;
    }

    public static class PreparedStatementHandler
    implements PreparedStatementCreator,
    PreparedStatementBinder,
    CqlProvider {
        private final SimpleStatement statement;

        public PreparedStatementHandler(Statement<?> statement) {
            this.statement = PreparedStatementDelegate.getStatementForPrepare(statement);
        }

        @Override
        public PreparedStatement createPreparedStatement(CqlSession session) throws DriverException {
            return session.prepare(this.statement.getQuery());
        }

        @Override
        public BoundStatement bindValues(PreparedStatement ps) throws DriverException {
            return PreparedStatementDelegate.bind(this.statement, ps);
        }

        @Override
        public String getCql() {
            return this.statement.getQuery();
        }
    }
}

