/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.cassandra.core.mapping.event.AbstractDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterConvertEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterLoadEvent;
import org.springframework.data.cassandra.core.mapping.event.AfterSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeDeleteEvent;
import org.springframework.data.cassandra.core.mapping.event.BeforeSaveEvent;
import org.springframework.data.cassandra.core.mapping.event.CassandraMappingEvent;

public abstract class AbstractCassandraEventListener<E>
implements ApplicationListener<CassandraMappingEvent<?>> {
    protected static final Log log = LogFactory.getLog(AbstractCassandraEventListener.class);
    private final Class<?> domainClass;

    public AbstractCassandraEventListener() {
        Class typeArgument = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractCassandraEventListener.class);
        this.domainClass = typeArgument == null ? Object.class : typeArgument;
    }

    public void onApplicationEvent(CassandraMappingEvent<?> event) {
        Object source = event.getSource();
        if (event instanceof AfterLoadEvent) {
            AfterLoadEvent afterLoadEvent = (AfterLoadEvent)event;
            if (this.domainClass.isAssignableFrom(afterLoadEvent.getType())) {
                this.onAfterLoad((AfterLoadEvent)event);
            }
            return;
        }
        if (event instanceof AbstractDeleteEvent) {
            Class eventDomainType = ((AbstractDeleteEvent)event).getType();
            if (eventDomainType != null && this.domainClass.isAssignableFrom(eventDomainType)) {
                if (event instanceof BeforeDeleteEvent) {
                    this.onBeforeDelete((BeforeDeleteEvent)event);
                }
                if (event instanceof AfterDeleteEvent) {
                    this.onAfterDelete((AfterDeleteEvent)event);
                }
            }
            return;
        }
        if (!this.domainClass.isAssignableFrom(source.getClass())) {
            return;
        }
        if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave((BeforeSaveEvent)event);
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave((AfterSaveEvent)event);
        } else if (event instanceof AfterConvertEvent) {
            this.onAfterConvert((AfterConvertEvent)event);
        }
    }

    public void onBeforeSave(BeforeSaveEvent<E> event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("onBeforeSave(%s)", event.getSource()));
        }
    }

    public void onAfterSave(AfterSaveEvent<E> event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("onAfterSave(%s)", event.getSource()));
        }
    }

    public void onBeforeDelete(BeforeDeleteEvent<E> event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("onBeforeDelete(%s)", event.getSource()));
        }
    }

    public void onAfterDelete(AfterDeleteEvent<E> event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("onAfterDelete(%s)", event.getSource()));
        }
    }

    public void onAfterLoad(AfterLoadEvent<E> event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("onAfterLoad(%s)", event.getSource()));
        }
    }

    public void onAfterConvert(AfterConvertEvent<E> event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("onAfterConvert(%s)", event.getSource()));
        }
    }
}

