/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.querybuilder.condition.Condition;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.util.StatementBuilder;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class EntityOperations {
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final EntityProjectionIntrospector introspector;

    EntityOperations(CassandraConverter converter) {
        this((MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty>)converter.getMappingContext(), converter.getCustomConversions(), converter.getProjectionFactory());
    }

    EntityOperations(MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> context, CustomConversions conversions, ProjectionFactory projectionFactory) {
        this.mappingContext = context;
        this.introspector = EntityProjectionIntrospector.create((ProjectionFactory)projectionFactory, (EntityProjectionIntrospector.ProjectionPredicate)EntityProjectionIntrospector.ProjectionPredicate.typeHierarchy().and((target, underlyingType) -> !conversions.isSimpleType(target)), context);
    }

    public <T> Entity<T> forEntity(T entity) {
        Assert.notNull(entity, (String)"Bean must not be null");
        return MappedEntity.of(entity, this.getMappingContext());
    }

    public <T> AdaptibleEntity<T> forEntity(T entity, ConversionService conversionService) {
        Assert.notNull(entity, (String)"Bean must not be null");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null");
        return AdaptibleMappedEntity.of(entity, this.getMappingContext(), conversionService);
    }

    CassandraPersistentEntity<?> getRequiredPersistentEntity(Class<?> entityClass) {
        return (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass(entityClass));
    }

    CqlIdentifier getTableName(Class<?> entityClass) {
        return this.getRequiredPersistentEntity(entityClass).getTableName();
    }

    public <M, D> EntityProjection<M, D> introspectProjection(Class<M> resultType, Class<D> entityType) {
        return this.introspector.introspect(resultType, entityType);
    }

    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private static class MappedEntity<T>
    implements Entity<T> {
        private final CassandraPersistentEntity<?> entity;
        private final PersistentPropertyAccessor<T> propertyAccessor;

        protected MappedEntity(CassandraPersistentEntity<?> entity, PersistentPropertyAccessor<T> propertyAccessor) {
            this.entity = entity;
            this.propertyAccessor = propertyAccessor;
        }

        private static <T> MappedEntity<T> of(T bean, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> context) {
            CassandraPersistentEntity entity = (CassandraPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new MappedEntity<T>(entity, propertyAccessor);
        }

        @Override
        public T getBean() {
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public boolean isNew() {
            return this.entity.isNew(this.getBean());
        }

        @Override
        @Nullable
        public Object getIdentifier() {
            return this.propertyAccessor.getProperty(this.entity.getRequiredIdProperty());
        }

        @Override
        public boolean isVersionedEntity() {
            return this.entity.hasVersionProperty();
        }

        @Override
        @Nullable
        public Object getVersion() {
            return this.propertyAccessor.getProperty(this.entity.getRequiredVersionProperty());
        }
    }

    private static class AdaptibleMappedEntity<T>
    extends MappedEntity<T>
    implements AdaptibleEntity<T> {
        private final CassandraPersistentEntity<?> entity;
        private final ConvertingPropertyAccessor<T> propertyAccessor;

        private static <T> AdaptibleEntity<T> of(T bean, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, ConversionService conversionService) {
            CassandraPersistentEntity entity = (CassandraPersistentEntity)mappingContext.getRequiredPersistentEntity(bean.getClass());
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new AdaptibleMappedEntity<T>(entity, new ConvertingPropertyAccessor(propertyAccessor, conversionService));
        }

        private AdaptibleMappedEntity(CassandraPersistentEntity<?> entity, ConvertingPropertyAccessor<T> propertyAccessor) {
            super(entity, propertyAccessor);
            this.entity = entity;
            this.propertyAccessor = propertyAccessor;
        }

        @Override
        public StatementBuilder<Update> appendVersionCondition(StatementBuilder<Update> update, Number currentVersionNumber) {
            return update.bind((statement, factory) -> (Update)statement.if_((Condition)Condition.column((CqlIdentifier)this.getVersionColumnName()).isEqualTo(factory.create(currentVersionNumber))));
        }

        @Override
        public StatementBuilder<Delete> appendVersionCondition(StatementBuilder<Delete> delete) {
            return delete.bind((statement, factory) -> (Delete)statement.if_((Condition)Condition.column((CqlIdentifier)this.getVersionColumnName()).isEqualTo(factory.create(this.getVersion()))));
        }

        @Override
        public T initializeVersionProperty() {
            if (this.entity.hasVersionProperty()) {
                CassandraPersistentProperty versionProperty;
                this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)((versionProperty = (CassandraPersistentProperty)this.entity.getRequiredVersionProperty()).getType().isPrimitive() ? 1 : 0));
            }
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public T incrementVersion() {
            CassandraPersistentProperty versionProperty = (CassandraPersistentProperty)this.entity.getRequiredVersionProperty();
            Number version = this.getVersion();
            Long nextVersion = version == null ? 0L : version.longValue() + 1L;
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)nextVersion);
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        @Nullable
        public Number getVersion() {
            CassandraPersistentProperty versionProperty = (CassandraPersistentProperty)this.entity.getRequiredVersionProperty();
            return (Number)this.propertyAccessor.getProperty((PersistentProperty)versionProperty, Number.class);
        }

        @Override
        public CassandraPersistentEntity<?> getPersistentEntity() {
            return this.entity;
        }

        private CqlIdentifier getVersionColumnName() {
            return ((CassandraPersistentProperty)this.entity.getRequiredVersionProperty()).getColumnName();
        }
    }

    static interface AdaptibleEntity<T>
    extends Entity<T> {
        public StatementBuilder<Update> appendVersionCondition(StatementBuilder<Update> var1, Number var2);

        public StatementBuilder<Delete> appendVersionCondition(StatementBuilder<Delete> var1);

        public T initializeVersionProperty();

        public T incrementVersion();

        @Override
        @Nullable
        public Number getVersion();

        public CassandraPersistentEntity<?> getPersistentEntity();
    }

    static interface Entity<T> {
        @Nullable
        public Object getIdentifier();

        default public boolean isVersionedEntity() {
            return false;
        }

        @Nullable
        public Object getVersion();

        public T getBean();

        public boolean isNew();
    }
}

