/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface CassandraPersistentEntity<T>
extends PersistentEntity<T, CassandraPersistentProperty> {
    @Nullable
    public CassandraPersistentProperty getProperty(Parameter<?, CassandraPersistentProperty> var1);

    public boolean isCompositePrimaryKey();

    @Deprecated(forRemoval=true)
    public void setForceQuote(boolean var1);

    public com.datastax.oss.driver.api.core.CqlIdentifier getTableName();

    @Deprecated(forRemoval=true)
    default public void setTableName(CqlIdentifier tableName) {
        Assert.notNull((Object)tableName, (String)"Table name must not be null");
        this.setTableName(tableName.toCqlIdentifier());
    }

    public void setTableName(com.datastax.oss.driver.api.core.CqlIdentifier var1);

    @Nullable
    public com.datastax.oss.driver.api.core.CqlIdentifier getKeyspace();

    default public com.datastax.oss.driver.api.core.CqlIdentifier getRequiredKeyspace() {
        com.datastax.oss.driver.api.core.CqlIdentifier keyspace = this.getKeyspace();
        if (keyspace == null) {
            throw new IllegalStateException(String.format("No keyspace specified for %s", this));
        }
        return keyspace;
    }

    default public boolean hasKeyspace() {
        return this.getKeyspace() != null;
    }

    public void setKeyspace(com.datastax.oss.driver.api.core.CqlIdentifier var1);

    public boolean isTupleType();

    public boolean isUserDefinedType();
}

