/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.generator;

import java.util.Map;
import org.springframework.data.cassandra.core.cql.generator.KeyspaceOptionsCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.AlterKeyspaceSpecification;

public class AlterKeyspaceCqlGenerator
extends KeyspaceOptionsCqlGenerator<AlterKeyspaceSpecification> {
    public AlterKeyspaceCqlGenerator(AlterKeyspaceSpecification specification) {
        super(specification);
    }

    public static String toCql(AlterKeyspaceSpecification specification) {
        return new AlterKeyspaceCqlGenerator(specification).toCql();
    }

    @Override
    public StringBuilder toCql(StringBuilder cql) {
        this.preambleCql(cql);
        this.optionsCql(cql);
        cql.append(";");
        return cql;
    }

    private void preambleCql(StringBuilder cql) {
        cql.append("ALTER KEYSPACE ").append(((AlterKeyspaceSpecification)this.spec()).getName().asCql(true)).append(" ");
    }

    private void optionsCql(StringBuilder cql) {
        Map<String, Object> options = ((AlterKeyspaceSpecification)this.spec()).getOptions();
        if (!options.isEmpty()) {
            boolean first = true;
            cql.append(" WITH ");
            if (!options.isEmpty()) {
                for (String name : options.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        cql.append(" AND ");
                    }
                    cql.append(name);
                    Object value = options.get(name);
                    if (value == null) continue;
                    cql.append(" = ");
                    if (value instanceof Map) {
                        this.optionValueMap((Map)value, cql);
                        continue;
                    }
                    cql.append(value.toString());
                }
            }
        }
    }
}

