/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.cassandra.repository.query.BindingContext;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class StringBasedQuery {
    private final String query;
    private final CassandraParameters parameters;
    private final ValueExpressionDelegate expressionParser;
    private final List<BindingContext.ParameterBinding> queryParameterBindings = new ArrayList<BindingContext.ParameterBinding>();
    private final ExpressionDependencies expressionDependencies;

    StringBasedQuery(String query2, CassandraParameters parameters, ValueExpressionDelegate expressionParser) {
        this.query = ParameterBindingParser.INSTANCE.parseAndCollectParameterBindingsFromQueryIntoBindings(query2, this.queryParameterBindings);
        this.parameters = parameters;
        this.expressionParser = expressionParser;
        this.expressionDependencies = this.createExpressionDependencies();
    }

    private ExpressionDependencies createExpressionDependencies() {
        if (this.queryParameterBindings.isEmpty()) {
            return ExpressionDependencies.none();
        }
        ArrayList<ExpressionDependencies> dependencies = new ArrayList<ExpressionDependencies>();
        for (BindingContext.ParameterBinding binding : this.queryParameterBindings) {
            if (!binding.isExpression()) continue;
            dependencies.add(this.expressionParser.parse(binding.getRequiredExpression()).getExpressionDependencies());
        }
        return ExpressionDependencies.merged(dependencies);
    }

    public ExpressionDependencies getExpressionDependencies() {
        return this.expressionDependencies;
    }

    SimpleStatement bindQuery(CassandraParameterAccessor parameterAccessor, ValueExpressionEvaluator evaluator) {
        Assert.notNull((Object)parameterAccessor, (String)"CassandraParameterAccessor must not be null");
        Assert.notNull((Object)evaluator, (String)"SpELExpressionEvaluator must not be null");
        BindingContext bindingContext = new BindingContext(this.parameters, parameterAccessor, this.queryParameterBindings, evaluator);
        List<Object> arguments = bindingContext.getBindingValues();
        return ParameterBinder.INSTANCE.bind(this.query, arguments);
    }

    static enum ParameterBindingParser {
        INSTANCE;

        private static final char CURRLY_BRACE_OPEN = '{';
        private static final char CURRLY_BRACE_CLOSE = '}';
        private static final Pattern INDEX_PARAMETER_BINDING_PATTERN;
        private static final Pattern NAMED_PARAMETER_BINDING_PATTERN;
        private static final Pattern INDEX_BASED_EXPRESSION_PATTERN;
        private static final Pattern NAME_BASED_EXPRESSION_PATTERN;
        private static final Pattern INDEX_BASED_PROPERTY_PLACEHOLDER_PATTERN;
        private static final Pattern NAME_BASED_PROPERTY_PLACEHOLDER_PATTERN;
        private static final Set<Pattern> VALUE_EXPRESSION_PATTERNS;
        private static final String ARGUMENT_PLACEHOLDER = "?_param_?";

        public String parseAndCollectParameterBindingsFromQueryIntoBindings(String input, List<BindingContext.ParameterBinding> bindings) {
            if (!StringUtils.hasText((String)input)) {
                return input;
            }
            Assert.notNull(bindings, (String)"Parameter bindings must not be null");
            return ParameterBindingParser.transformQueryAndCollectExpressionParametersIntoBindings(input, bindings);
        }

        private static String transformQueryAndCollectExpressionParametersIntoBindings(String input, List<BindingContext.ParameterBinding> bindings) {
            Matcher matcher;
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPosition = 0;
            while (currentPosition < input.length() && (matcher = ParameterBindingParser.findNextBindingOrExpression(input, currentPosition)) != null) {
                int exprStart;
                currentPosition = exprStart = matcher.start();
                if (ParameterBindingParser.isValueExpression(matcher)) {
                    int curlyBraceOpenCount = 1;
                    currentPosition += 3;
                    block5: while (curlyBraceOpenCount > 0 && currentPosition < input.length()) {
                        switch (input.charAt(currentPosition++)) {
                            case '{': {
                                ++curlyBraceOpenCount;
                                continue block5;
                            }
                            case '}': {
                                --curlyBraceOpenCount;
                                continue block5;
                            }
                        }
                    }
                    result.append(input.subSequence(startIndex, exprStart));
                } else {
                    result.append(input.subSequence(startIndex, exprStart));
                }
                result.append(ARGUMENT_PLACEHOLDER);
                if (ParameterBindingParser.isValueExpression(matcher)) {
                    bindings.add(BindingContext.ParameterBinding.expression(input.substring(exprStart + 1, currentPosition), true));
                } else {
                    if (matcher.pattern() == INDEX_PARAMETER_BINDING_PATTERN) {
                        bindings.add(BindingContext.ParameterBinding.indexed(Integer.parseInt(matcher.group(1))));
                    } else {
                        bindings.add(BindingContext.ParameterBinding.named(matcher.group(1)));
                    }
                    currentPosition = matcher.end();
                }
                startIndex = currentPosition;
            }
            return result.append(input.subSequence(currentPosition, input.length())).toString();
        }

        private static boolean isValueExpression(Matcher matcher) {
            return VALUE_EXPRESSION_PATTERNS.contains(matcher.pattern());
        }

        @Nullable
        private static Matcher findNextBindingOrExpression(String input, int startPosition) {
            ArrayList<Matcher> matchers = new ArrayList<Matcher>(6);
            matchers.add(INDEX_PARAMETER_BINDING_PATTERN.matcher(input));
            matchers.add(NAMED_PARAMETER_BINDING_PATTERN.matcher(input));
            matchers.add(INDEX_BASED_EXPRESSION_PATTERN.matcher(input));
            matchers.add(NAME_BASED_EXPRESSION_PATTERN.matcher(input));
            matchers.add(INDEX_BASED_PROPERTY_PLACEHOLDER_PATTERN.matcher(input));
            matchers.add(NAME_BASED_PROPERTY_PLACEHOLDER_PATTERN.matcher(input));
            TreeMap<Integer, Matcher> matcherMap = new TreeMap<Integer, Matcher>();
            for (Matcher matcher : matchers) {
                if (!matcher.find(startPosition)) continue;
                matcherMap.put(matcher.start(), matcher);
            }
            return matcherMap.isEmpty() ? null : (Matcher)matcherMap.values().iterator().next();
        }

        static {
            INDEX_PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");
            NAMED_PARAMETER_BINDING_PATTERN = Pattern.compile("\\:(\\w+)");
            INDEX_BASED_EXPRESSION_PATTERN = Pattern.compile("\\?\\#\\{");
            NAME_BASED_EXPRESSION_PATTERN = Pattern.compile("\\:\\#\\{");
            INDEX_BASED_PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("\\?\\$\\{");
            NAME_BASED_PROPERTY_PLACEHOLDER_PATTERN = Pattern.compile("\\:\\$\\{");
            VALUE_EXPRESSION_PATTERNS = Set.of(INDEX_BASED_EXPRESSION_PATTERN, NAME_BASED_EXPRESSION_PATTERN, INDEX_BASED_PROPERTY_PLACEHOLDER_PATTERN, NAME_BASED_PROPERTY_PLACEHOLDER_PATTERN);
        }
    }

    static enum ParameterBinder {
        INSTANCE;

        private static final String ARGUMENT_PLACEHOLDER = "?_param_?";
        private static final Pattern ARGUMENT_PLACEHOLDER_PATTERN;

        public SimpleStatement bind(String input, List<Object> parameters) {
            if (parameters.isEmpty()) {
                return SimpleStatement.newInstance((String)input);
            }
            StringBuilder result = new StringBuilder();
            int startIndex = 0;
            int currentPosition = 0;
            int parameterIndex = 0;
            Matcher matcher = ARGUMENT_PLACEHOLDER_PATTERN.matcher(input);
            while (currentPosition < input.length() && matcher.find()) {
                int exprStart = matcher.start();
                result.append(input.subSequence(startIndex, exprStart)).append("?");
                ++parameterIndex;
                startIndex = currentPosition = matcher.end();
            }
            String bindableStatement = result.append(input.subSequence(currentPosition, input.length())).toString();
            return SimpleStatement.newInstance((String)bindableStatement, (Object[])parameters.subList(0, parameterIndex).toArray());
        }

        static {
            ARGUMENT_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote(ARGUMENT_PLACEHOLDER));
        }
    }
}

