/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.cassandra.config.InitializeKeyspaceBeanDefinitionParser;
import org.springframework.data.cassandra.config.ParsingUtils;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.config.SessionFactoryFactoryBean;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class SessionFactoryBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    SessionFactoryBeanDefinitionParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return SessionFactoryFactoryBean.class;
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String id = super.resolveId(element, definition, parserContext);
        return StringUtils.hasText((String)id) ? id : "cassandraSessionFactory";
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.addOptionalPropertyReference(builder, "session", element, "session-ref", "cassandraSession");
        ParsingUtils.addOptionalPropertyReference(builder, "converter", element, "cassandra-converter-ref", "cassandraConverter");
        ParsingUtils.addOptionalPropertyValue(builder, "schemaAction", element, "schema-action", SchemaAction.NONE.name());
        InitializeKeyspaceBeanDefinitionParser.parseKeyspacePopulator(element, builder);
        builder.getRawBeanDefinition().setSource((Object)element);
    }
}

