/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.cassandra.core.cql.RowMapper;
import org.springframework.data.cassandra.core.query.CassandraPageRequest;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.SliceImpl;
import org.springframework.lang.Nullable;

class EntityQueryUtils {
    private static final Pattern FROM_REGEX = Pattern.compile(" FROM ([\"]?[\\w]*[\\\\.]?[\\w]*[\"]?)[\\s]?", 2);

    EntityQueryUtils() {
    }

    static <T> Slice<T> readSlice(ResultSet resultSet, RowMapper<T> mapper, int page, int pageSize) {
        int toRead = resultSet.getAvailableWithoutFetching();
        return EntityQueryUtils.readSlice(() -> EntityQueryUtils.limit(resultSet.iterator(), toRead), resultSet.getExecutionInfo().getPagingState(), mapper, page, pageSize);
    }

    static <T> Slice<T> readSlice(AsyncResultSet resultSet, RowMapper<T> mapper, int page, int pageSize) {
        return EntityQueryUtils.readSlice(() -> EntityQueryUtils.limit(resultSet.currentPage().iterator(), resultSet.remaining()), resultSet.getExecutionInfo().getPagingState(), mapper, page, pageSize);
    }

    static <T> Slice<T> readSlice(Iterable<Row> rows, @Nullable ByteBuffer pagingState, RowMapper<T> mapper, int page, int pageSize) {
        ArrayList<T> result = new ArrayList<T>(pageSize);
        Iterator<Row> iterator = rows.iterator();
        int index = 0;
        while (iterator.hasNext()) {
            T element = mapper.mapRow(iterator.next(), index++);
            result.add(element);
        }
        CassandraPageRequest pageRequest = CassandraPageRequest.of((Pageable)PageRequest.of((int)page, (int)pageSize), pagingState);
        return new SliceImpl(result, (Pageable)pageRequest, pagingState != null);
    }

    static CqlIdentifier getTableName(Statement<?> statement) {
        String cql = statement instanceof SimpleStatement ? ((SimpleStatement)statement).getQuery() : statement.toString();
        Matcher matcher = FROM_REGEX.matcher(cql);
        if (matcher.find()) {
            String cqlTableName = matcher.group(1);
            int separator = cqlTableName.indexOf(46);
            if (separator != -1) {
                cqlTableName = cqlTableName.substring(separator + 1);
            }
            if (cqlTableName.startsWith("\"") || cqlTableName.endsWith("\"")) {
                return CqlIdentifier.fromCql((String)cqlTableName.substring(separator + 1));
            }
            return CqlIdentifier.fromInternal((String)cqlTableName);
        }
        return CqlIdentifier.fromCql((String)"unknown");
    }

    private static <T> Iterator<T> limit(final Iterator<T> iterator, final int limitSize) {
        return new Iterator<T>(){
            private int count;

            @Override
            public boolean hasNext() {
                return this.count < limitSize && iterator.hasNext();
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }
}

