/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.cdi;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.support.CassandraRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CassandraRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<CassandraOperations> cassandraOperationsBean;

    public CassandraRepositoryBean(Bean<CassandraOperations> operations, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, @Nullable CustomRepositoryImplementationDetector detector) {
        super(qualifiers, repositoryType, beanManager, Optional.ofNullable(detector));
        Assert.notNull(operations, (String)"Cannot create repository with 'null' for CassandraOperations");
        this.cassandraOperationsBean = operations;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType) {
        CassandraOperations cassandraOperations = (CassandraOperations)this.getDependencyInstance(this.cassandraOperationsBean, CassandraOperations.class);
        return (T)this.create(() -> new CassandraRepositoryFactory(cassandraOperations), repositoryType);
    }

    public Class<? extends Annotation> getScope() {
        return this.cassandraOperationsBean.getScope();
    }
}

