/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.AbstractReactiveCassandraQuery;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.ConvertingParameterAccessor;
import org.springframework.data.cassandra.repository.query.DefaultSpELExpressionEvaluator;
import org.springframework.data.cassandra.repository.query.ProjectionUtil;
import org.springframework.data.cassandra.repository.query.ReactiveCassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ReactiveQueryMethodEvaluationContextProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveStringBasedCassandraQuery
extends AbstractReactiveCassandraQuery {
    private static final String COUNT_AND_EXISTS = "Manually defined query for %s cannot be a count and exists query at the same time";
    private final StringBasedQuery stringBasedQuery;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;
    private final ExpressionParser expressionParser;
    private final ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider;

    public ReactiveStringBasedCassandraQuery(ReactiveCassandraQueryMethod queryMethod, ReactiveCassandraOperations operations, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(queryMethod.getRequiredAnnotatedQuery(), queryMethod, operations, expressionParser, evaluationContextProvider);
    }

    public ReactiveStringBasedCassandraQuery(String query2, ReactiveCassandraQueryMethod method, ReactiveCassandraOperations operations, ExpressionParser expressionParser, ReactiveQueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations);
        Assert.hasText((String)query2, (String)"Query must not be empty");
        this.expressionParser = expressionParser;
        this.evaluationContextProvider = evaluationContextProvider;
        this.stringBasedQuery = new StringBasedQuery(query2, method.getParameters(), expressionParser);
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getQueryAnnotation().orElse(null);
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            if (ProjectionUtil.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery)) {
                throw new IllegalArgumentException(String.format(COUNT_AND_EXISTS, new Object[]{method}));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
        }
    }

    protected StringBasedQuery getStringBasedQuery() {
        return this.stringBasedQuery;
    }

    @Override
    public Mono<SimpleStatement> createQuery(CassandraParameterAccessor parameterAccessor) {
        StringBasedQuery query2 = this.getStringBasedQuery();
        ConvertingParameterAccessor parameterAccessorToUse = new ConvertingParameterAccessor(this.getReactiveCassandraOperations().getConverter(), parameterAccessor);
        Mono<SpELExpressionEvaluator> spelEvaluator = this.getSpelEvaluatorFor(query2.getExpressionDependencies(), parameterAccessorToUse);
        return spelEvaluator.map(it -> this.getQueryStatementCreator().select(query2, parameterAccessorToUse, (SpELExpressionEvaluator)it));
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }

    @Override
    protected boolean isModifyingQuery() {
        return false;
    }

    private Mono<SpELExpressionEvaluator> getSpelEvaluatorFor(ExpressionDependencies dependencies, CassandraParameterAccessor accessor) {
        return this.evaluationContextProvider.getEvaluationContextLater((Parameters)this.getQueryMethod().getParameters(), accessor.getValues(), dependencies).map(evaluationContext -> new DefaultSpELExpressionEvaluator(this.expressionParser, (EvaluationContext)evaluationContext)).defaultIfEmpty((Object)DefaultSpELExpressionEvaluator.unsupported());
    }
}

