/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.observability;

import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.docs.ObservationDocumentation;
import io.micrometer.tracing.docs.EventValue;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum CassandraObservation implements ObservationDocumentation
{
    CASSANDRA_QUERY_OBSERVATION{

        public String getName() {
            return "spring.data.cassandra.query";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return LowCardinalityKeyNames.values();
        }

        public KeyName[] getHighCardinalityKeyNames() {
            return HighCardinalityKeyNames.values();
        }
    };


    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Events implements EventValue
    {
        NODE_ERROR{

            public String getValue() {
                return "cassandra.node.error";
            }
        }
        ,
        NODE_SUCCESS{

            public String getValue() {
                return "cassandra.node.success";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum HighCardinalityKeyNames implements KeyName
    {
        DB_STATEMENT{

            public String asString() {
                return "db.statement";
            }
        }
        ,
        PAGE_SIZE{

            public String asString() {
                return "db.cassandra.page_size";
            }
        }
        ,
        CONSISTENCY_LEVEL{

            public String asString() {
                return "db.cassandra.consistency_level";
            }
        }
        ,
        IDEMPOTENCE{

            public String asString() {
                return "db.cassandra.idempotence";
            }
        }
        ,
        NODE_ERROR_TAG{

            public String asString() {
                return "spring.data.cassandra.node[%s].error";
            }
        };

    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum LowCardinalityKeyNames implements KeyName
    {
        DATABASE_SYSTEM{

            public String asString() {
                return "db.system";
            }
        }
        ,
        NET_TRANSPORT{

            public String asString() {
                return "net.transport";
            }
        }
        ,
        NET_PEER_NAME{

            public String asString() {
                return "net.peer.name";
            }
        }
        ,
        NET_PEER_PORT{

            public String asString() {
                return "net.peer.port";
            }
        }
        ,
        NET_SOCK_PEER_ADDR{

            public String asString() {
                return "net.sock.peer.addr";
            }
        }
        ,
        NET_SOCK_PEER_PORT{

            public String asString() {
                return "net.sock.peer.port";
            }
        }
        ,
        KEYSPACE_NAME{

            public String asString() {
                return "db.name";
            }
        }
        ,
        SESSION_NAME{

            public String asString() {
                return "spring.data.cassandra.sessionName";
            }
        }
        ,
        METHOD_NAME{

            public String asString() {
                return "spring.data.cassandra.methodName";
            }
        }
        ,
        DB_OPERATION{

            public String asString() {
                return "db.operation";
            }
        }
        ,
        COORDINATOR{

            public String asString() {
                return "db.cassandra.coordinator.id";
            }
        }
        ,
        COORDINATOR_DC{

            public String asString() {
                return "db.cassandra.coordinator.dc";
            }
        };

    }
}

