/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

class CassandraConstructorProperty
implements CassandraPersistentProperty {
    private final String name;
    private final CassandraPersistentEntity<?> owner;
    private final TypeInformation<?> typeInformation;

    public CassandraConstructorProperty(String name, CassandraPersistentEntity<?> owner, TypeInformation<?> typeInformation) {
        this.name = name;
        this.owner = owner;
        this.typeInformation = typeInformation;
    }

    @Override
    @Nullable
    public CqlIdentifier getColumnName() {
        throw new IllegalStateException(String.format("Parameter %s is not annotated with @Column", this.name));
    }

    @Override
    @Nullable
    public Integer getOrdinal() {
        throw new IllegalStateException(String.format("Parameter %s is not annotated with @Element", this.name));
    }

    @Override
    @Nullable
    public Ordering getPrimaryKeyOrdering() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isClusterKeyColumn() {
        return false;
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return false;
    }

    @Override
    public boolean isMapLike() {
        return this.typeInformation.isMap();
    }

    @Override
    public boolean isPartitionKeyColumn() {
        return false;
    }

    @Override
    public boolean isPrimaryKeyColumn() {
        return false;
    }

    @Override
    public boolean isStaticColumn() {
        return false;
    }

    @Override
    @Nullable
    public AnnotatedType findAnnotatedType(Class<? extends Annotation> annotationType) {
        return null;
    }

    public PersistentEntity<?, CassandraPersistentProperty> getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean hasExplicitColumnName() {
        return false;
    }

    public Class<?> getType() {
        return null;
    }

    public TypeInformation<?> getTypeInformation() {
        return this.typeInformation;
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypes() {
        return Collections.emptyList();
    }

    @Nullable
    public Method getGetter() {
        return null;
    }

    @Nullable
    public Method getSetter() {
        return null;
    }

    @Nullable
    public Method getWither() {
        return null;
    }

    @Nullable
    public Field getField() {
        return null;
    }

    @Nullable
    public String getSpelExpression() {
        return null;
    }

    @Nullable
    public Association<CassandraPersistentProperty> getAssociation() {
        return null;
    }

    public boolean isEntity() {
        return false;
    }

    public boolean isIdProperty() {
        return false;
    }

    public boolean isVersionProperty() {
        return false;
    }

    public boolean isCollectionLike() {
        return this.typeInformation.isCollectionLike();
    }

    public boolean isMap() {
        return this.typeInformation.isMap();
    }

    public boolean isArray() {
        return this.typeInformation.getType().isArray();
    }

    public boolean isTransient() {
        return false;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isImmutable() {
        return false;
    }

    public boolean isAssociation() {
        return false;
    }

    @Nullable
    public Class<?> getComponentType() {
        return Optional.ofNullable(this.typeInformation.getComponentType()).map(TypeInformation::getType).orElse(null);
    }

    public Class<?> getRawType() {
        return this.typeInformation.getType();
    }

    @Nullable
    public Class<?> getMapValueType() {
        return Optional.ofNullable(this.typeInformation.getMapValueType()).map(TypeInformation::getType).orElse(null);
    }

    public Class<?> getActualType() {
        return this.typeInformation.getRequiredActualType().getType();
    }

    @Nullable
    public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
        return null;
    }

    @Nullable
    public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
        return null;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return false;
    }

    public boolean usePropertyAccess() {
        return false;
    }

    @Nullable
    public Class<?> getAssociationTargetType() {
        return null;
    }

    public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation() {
        return Collections.emptyList();
    }

    @Nullable
    public TypeInformation<?> getAssociationTargetTypeInformation() {
        return null;
    }

    @Override
    public void setColumnName(CqlIdentifier columnName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void setForceQuote(boolean forceQuote) {
        throw new UnsupportedOperationException();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        throw new UnsupportedOperationException();
    }
}

