/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.oss.driver.api.core.cql.BatchStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.api.querybuilder.insert.Insert;
import com.datastax.oss.driver.api.querybuilder.update.Update;
import com.datastax.oss.driver.api.querybuilder.update.UpdateStart;
import java.time.Duration;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.WriteOptions;
import org.springframework.util.Assert;

public abstract class QueryOptionsUtil {
    public static <T extends Statement<?>> T addQueryOptions(T statement, QueryOptions queryOptions) {
        Assert.notNull(statement, (String)"Statement must not be null");
        Object statementToUse = statement;
        if (queryOptions.getConsistencyLevel() != null) {
            statementToUse = statementToUse.setConsistencyLevel(queryOptions.getConsistencyLevel());
        }
        statementToUse = queryOptions.getExecutionProfileResolver().apply((Statement<?>)statementToUse);
        if (queryOptions.isIdempotent() != null) {
            statementToUse = statementToUse.setIdempotent(queryOptions.isIdempotent());
        }
        if (queryOptions.getPageSize() != null) {
            statementToUse = statementToUse.setPageSize(queryOptions.getPageSize().intValue());
        }
        if (queryOptions.getRoutingKeyspace() != null) {
            statementToUse = statementToUse.setRoutingKeyspace(queryOptions.getRoutingKeyspace());
        }
        if (queryOptions.getRoutingKey() != null) {
            statementToUse = statement.setRoutingKey(queryOptions.getRoutingKey());
        }
        if (queryOptions.getSerialConsistencyLevel() != null) {
            statementToUse = statementToUse.setSerialConsistencyLevel(queryOptions.getSerialConsistencyLevel());
        }
        if (!queryOptions.getTimeout().isNegative()) {
            statementToUse = statementToUse.setTimeout(queryOptions.getTimeout());
        }
        if (queryOptions.getTracing() != null) {
            statementToUse = statementToUse.setTracing(Boolean.TRUE.equals(queryOptions.getTracing()));
        }
        if (queryOptions.getKeyspace() != null) {
            if (statementToUse instanceof BoundStatement) {
                throw new IllegalArgumentException("Keyspace cannot be set for a BoundStatement");
            }
            if (statementToUse instanceof BatchStatement) {
                statementToUse = ((BatchStatement)statementToUse).setKeyspace(queryOptions.getKeyspace());
            }
            if (statementToUse instanceof SimpleStatement) {
                statementToUse = ((SimpleStatement)statementToUse).setKeyspace(queryOptions.getKeyspace());
            }
        }
        return statementToUse;
    }

    public static Insert addWriteOptions(Insert insert, WriteOptions writeOptions) {
        Assert.notNull((Object)insert, (String)"Insert must not be null");
        Assert.notNull((Object)writeOptions, (String)"WriteOptions must not be null");
        Insert insertToUse = insert;
        if (!writeOptions.getTtl().isNegative()) {
            insertToUse = insertToUse.usingTtl(Math.toIntExact(writeOptions.getTtl().getSeconds()));
        }
        if (writeOptions.getTimestamp() != null) {
            insertToUse = insertToUse.usingTimestamp(writeOptions.getTimestamp().longValue());
        }
        return insertToUse;
    }

    public static Delete addWriteOptions(Delete delete, WriteOptions writeOptions) {
        Assert.notNull((Object)delete, (String)"Delete must not be null");
        Assert.notNull((Object)writeOptions, (String)"WriteOptions must not be null");
        if (writeOptions.getTimestamp() != null) {
            delete = (Delete)((DeleteSelection)delete).usingTimestamp(writeOptions.getTimestamp().longValue());
        }
        return delete;
    }

    public static Update addWriteOptions(Update update, WriteOptions writeOptions) {
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull((Object)writeOptions, (String)"WriteOptions must not be null");
        if (QueryOptionsUtil.hasTtl(writeOptions.getTtl())) {
            update = (Update)((UpdateStart)update).usingTtl(QueryOptionsUtil.getTtlSeconds(writeOptions.getTtl()));
        }
        if (writeOptions.getTimestamp() != null) {
            update = (Update)((UpdateStart)update).usingTimestamp(writeOptions.getTimestamp().longValue());
        }
        return update;
    }

    private static int getTtlSeconds(Duration ttl) {
        return Math.toIntExact(ttl.getSeconds());
    }

    private static boolean hasTtl(Duration ttl) {
        return !ttl.isZero() && !ttl.isNegative();
    }
}

