/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.Ordering;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Embedded;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.InstanceCreatorMetadata;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class EmbeddedEntityOperations {
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;

    public EmbeddedEntityOperations(MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext) {
        this.mappingContext = mappingContext;
    }

    public CassandraPersistentEntity<?> getEntity(CassandraPersistentProperty property) {
        return EmbeddedEntityOperations.withPrefix(EmbeddedEntityOperations.getPrefix(property), (CassandraPersistentEntity)this.mappingContext.getPersistentEntity((PersistentProperty)property));
    }

    static <T> CassandraPersistentEntity<T> withPrefix(@Nullable String prefix, CassandraPersistentEntity<T> source) {
        if (!StringUtils.hasText((String)prefix)) {
            return source;
        }
        return new PrefixedCassandraPersistentEntity<T>(prefix, source);
    }

    @Nullable
    static String getPrefix(CassandraPersistentProperty property) {
        Embedded embedded = (Embedded)property.findAnnotation(Embedded.class);
        return embedded != null ? embedded.prefix() : null;
    }

    static class PrefixedCassandraPersistentProperty
    implements CassandraPersistentProperty {
        private final String prefix;
        private final CassandraPersistentProperty delegate;

        public PrefixedCassandraPersistentProperty(String prefix, CassandraPersistentProperty delegate) {
            this.prefix = prefix;
            this.delegate = delegate;
        }

        @Override
        @Deprecated
        public void setColumnName(CqlIdentifier columnName) {
            this.delegate.setColumnName(columnName);
        }

        @Override
        public void setColumnName(com.datastax.oss.driver.api.core.CqlIdentifier columnName) {
            this.delegate.setColumnName(columnName);
        }

        @Override
        public com.datastax.oss.driver.api.core.CqlIdentifier getColumnName() {
            return com.datastax.oss.driver.api.core.CqlIdentifier.fromInternal((String)(this.prefix + this.delegate.getColumnName().asInternal()));
        }

        @Override
        @Deprecated
        public void setForceQuote(boolean forceQuote) {
            this.delegate.setForceQuote(forceQuote);
        }

        @Override
        public boolean hasExplicitColumnName() {
            return false;
        }

        @Override
        @Nullable
        public Integer getOrdinal() {
            return this.delegate.getOrdinal();
        }

        @Override
        public int getRequiredOrdinal() {
            return this.delegate.getRequiredOrdinal();
        }

        @Override
        @Nullable
        public Ordering getPrimaryKeyOrdering() {
            return this.delegate.getPrimaryKeyOrdering();
        }

        @Override
        public boolean isClusterKeyColumn() {
            return this.delegate.isClusterKeyColumn();
        }

        @Override
        public boolean isCompositePrimaryKey() {
            return this.delegate.isCompositePrimaryKey();
        }

        @Override
        public boolean isMapLike() {
            return this.delegate.isMapLike();
        }

        @Override
        public boolean isPartitionKeyColumn() {
            return this.delegate.isPartitionKeyColumn();
        }

        @Override
        public boolean isPrimaryKeyColumn() {
            return this.delegate.isPrimaryKeyColumn();
        }

        @Override
        public boolean isEmbedded() {
            return this.delegate.isEmbedded();
        }

        @Override
        public boolean isStaticColumn() {
            return this.delegate.isStaticColumn();
        }

        @Override
        @Nullable
        public AnnotatedType findAnnotatedType(Class<? extends Annotation> annotationType) {
            return this.delegate.findAnnotatedType(annotationType);
        }

        public PersistentEntity<?, CassandraPersistentProperty> getOwner() {
            return this.delegate.getOwner();
        }

        public String getName() {
            return this.delegate.getName();
        }

        public Class<?> getType() {
            return this.delegate.getType();
        }

        public TypeInformation<?> getTypeInformation() {
            return this.delegate.getTypeInformation();
        }

        public Iterable<? extends TypeInformation<?>> getPersistentEntityTypes() {
            return this.delegate.getPersistentEntityTypes();
        }

        @Nullable
        public Method getGetter() {
            return this.delegate.getGetter();
        }

        public Method getRequiredGetter() {
            return this.delegate.getRequiredGetter();
        }

        @Nullable
        public Method getSetter() {
            return this.delegate.getSetter();
        }

        public Method getRequiredSetter() {
            return this.delegate.getRequiredSetter();
        }

        @Nullable
        public Method getWither() {
            return this.delegate.getWither();
        }

        public Method getRequiredWither() {
            return this.delegate.getRequiredWither();
        }

        @Nullable
        public Field getField() {
            return this.delegate.getField();
        }

        public Field getRequiredField() {
            return this.delegate.getRequiredField();
        }

        @Nullable
        public String getSpelExpression() {
            return this.delegate.getSpelExpression();
        }

        @Nullable
        public Association<CassandraPersistentProperty> getAssociation() {
            return this.delegate.getAssociation();
        }

        public Association<CassandraPersistentProperty> getRequiredAssociation() {
            return this.delegate.getRequiredAssociation();
        }

        public boolean isEntity() {
            return this.delegate.isEntity();
        }

        public boolean isIdProperty() {
            return this.delegate.isIdProperty();
        }

        public boolean isVersionProperty() {
            return this.delegate.isVersionProperty();
        }

        public boolean isCollectionLike() {
            return this.delegate.isCollectionLike();
        }

        public boolean isMap() {
            return this.delegate.isMap();
        }

        public boolean isArray() {
            return this.delegate.isArray();
        }

        public boolean isTransient() {
            return this.delegate.isTransient();
        }

        public boolean isWritable() {
            return this.delegate.isWritable();
        }

        public boolean isImmutable() {
            return this.delegate.isImmutable();
        }

        public boolean isAssociation() {
            return this.delegate.isAssociation();
        }

        @Nullable
        public Class<?> getComponentType() {
            return this.delegate.getComponentType();
        }

        public Class<?> getRawType() {
            return this.delegate.getRawType();
        }

        @Nullable
        public Class<?> getMapValueType() {
            return this.delegate.getMapValueType();
        }

        public Class<?> getActualType() {
            return this.delegate.getActualType();
        }

        @Nullable
        public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
            return (A)this.delegate.findAnnotation(annotationType);
        }

        public <A extends Annotation> A getRequiredAnnotation(Class<A> annotationType) throws IllegalStateException {
            return (A)this.delegate.getRequiredAnnotation(annotationType);
        }

        @Nullable
        public <A extends Annotation> A findPropertyOrOwnerAnnotation(Class<A> annotationType) {
            return (A)this.delegate.findPropertyOrOwnerAnnotation(annotationType);
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.delegate.isAnnotationPresent(annotationType);
        }

        public boolean usePropertyAccess() {
            return this.delegate.usePropertyAccess();
        }

        public boolean hasActualTypeAnnotation(Class<? extends Annotation> annotationType) {
            return this.delegate.hasActualTypeAnnotation(annotationType);
        }

        @Nullable
        public Class<?> getAssociationTargetType() {
            return this.delegate.getAssociationTargetType();
        }

        public Iterable<? extends TypeInformation<?>> getPersistentEntityTypeInformation() {
            return this.delegate.getPersistentEntityTypeInformation();
        }

        @Nullable
        public TypeInformation<?> getAssociationTargetTypeInformation() {
            return this.delegate.getAssociationTargetTypeInformation();
        }

        public <T> PersistentPropertyAccessor<T> getAccessorForOwner(T owner) {
            return this.delegate.getAccessorForOwner(owner);
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.delegate.setApplicationContext(applicationContext);
        }
    }

    static class PrefixedCassandraPersistentEntity<T>
    implements CassandraPersistentEntity<T> {
        private final String prefix;
        private final CassandraPersistentEntity<T> delegate;

        public PrefixedCassandraPersistentEntity(String prefix, CassandraPersistentEntity<T> delegate) {
            this.prefix = prefix;
            this.delegate = delegate;
        }

        @Override
        public boolean isCompositePrimaryKey() {
            return this.delegate.isCompositePrimaryKey();
        }

        @Override
        @Deprecated
        public void setForceQuote(boolean forceQuote) {
            this.delegate.setForceQuote(forceQuote);
        }

        @Override
        public com.datastax.oss.driver.api.core.CqlIdentifier getTableName() {
            return this.delegate.getTableName();
        }

        @Override
        @Deprecated
        public void setTableName(CqlIdentifier tableName) {
            this.delegate.setTableName(tableName);
        }

        @Override
        public void setTableName(com.datastax.oss.driver.api.core.CqlIdentifier tableName) {
            this.delegate.setTableName(tableName);
        }

        @Override
        public boolean isTupleType() {
            return this.delegate.isTupleType();
        }

        @Override
        public boolean isUserDefinedType() {
            return this.delegate.isUserDefinedType();
        }

        public String getName() {
            return this.delegate.getName();
        }

        @Nullable
        public PreferredConstructor<T, CassandraPersistentProperty> getPersistenceConstructor() {
            return this.delegate.getPersistenceConstructor();
        }

        public InstanceCreatorMetadata<CassandraPersistentProperty> getInstanceCreatorMetadata() {
            return this.delegate.getInstanceCreatorMetadata();
        }

        public boolean isConstructorArgument(PersistentProperty<?> property) {
            return this.delegate.isConstructorArgument(property);
        }

        public boolean isCreatorArgument(PersistentProperty<?> property) {
            return this.delegate.isCreatorArgument(property);
        }

        public boolean isIdProperty(PersistentProperty<?> property) {
            return this.delegate.isIdProperty(property);
        }

        public boolean isVersionProperty(PersistentProperty<?> property) {
            return this.delegate.isVersionProperty(property);
        }

        @Nullable
        public CassandraPersistentProperty getIdProperty() {
            return (CassandraPersistentProperty)this.delegate.getIdProperty();
        }

        public CassandraPersistentProperty getRequiredIdProperty() {
            return (CassandraPersistentProperty)this.delegate.getRequiredIdProperty();
        }

        @Nullable
        public CassandraPersistentProperty getVersionProperty() {
            return (CassandraPersistentProperty)this.delegate.getVersionProperty();
        }

        public CassandraPersistentProperty getRequiredVersionProperty() {
            return (CassandraPersistentProperty)this.delegate.getRequiredVersionProperty();
        }

        @Nullable
        public CassandraPersistentProperty getPersistentProperty(String name) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)this.delegate.getPersistentProperty(name);
            return property == null ? null : new PrefixedCassandraPersistentProperty(this.prefix, property);
        }

        public CassandraPersistentProperty getRequiredPersistentProperty(String name) {
            return new PrefixedCassandraPersistentProperty(this.prefix, (CassandraPersistentProperty)this.delegate.getRequiredPersistentProperty(name));
        }

        @Nullable
        public CassandraPersistentProperty getPersistentProperty(Class<? extends Annotation> annotationType) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)this.delegate.getPersistentProperty(annotationType);
            return property == null ? null : new PrefixedCassandraPersistentProperty(this.prefix, property);
        }

        public Iterable<CassandraPersistentProperty> getPersistentProperties(Class<? extends Annotation> annotationType) {
            return this.delegate.getPersistentProperties(annotationType);
        }

        public boolean hasIdProperty() {
            return this.delegate.hasIdProperty();
        }

        public boolean hasVersionProperty() {
            return this.delegate.hasVersionProperty();
        }

        public Class<T> getType() {
            return this.delegate.getType();
        }

        public Alias getTypeAlias() {
            return this.delegate.getTypeAlias();
        }

        public TypeInformation<T> getTypeInformation() {
            return this.delegate.getTypeInformation();
        }

        public void doWithProperties(PropertyHandler<CassandraPersistentProperty> handler) {
            this.delegate.doWithProperties(property -> handler.doWithPersistentProperty((PersistentProperty)this.wrap((CassandraPersistentProperty)property)));
        }

        public void doWithProperties(SimplePropertyHandler handler) {
            this.delegate.doWithProperties(property -> {
                if (property instanceof CassandraPersistentProperty) {
                    handler.doWithPersistentProperty((PersistentProperty)this.wrap((CassandraPersistentProperty)property));
                } else {
                    handler.doWithPersistentProperty(property);
                }
            });
            this.delegate.doWithProperties(handler);
        }

        public void doWithAssociations(AssociationHandler<CassandraPersistentProperty> handler) {
            this.delegate.doWithAssociations(handler);
        }

        public void doWithAssociations(SimpleAssociationHandler handler) {
            this.delegate.doWithAssociations(handler);
        }

        @Nullable
        public <A extends Annotation> A findAnnotation(Class<A> annotationType) {
            return (A)this.delegate.findAnnotation(annotationType);
        }

        public <A extends Annotation> A getRequiredAnnotation(Class<A> annotationType) throws IllegalStateException {
            return (A)this.delegate.getRequiredAnnotation(annotationType);
        }

        public <A extends Annotation> boolean isAnnotationPresent(Class<A> annotationType) {
            return this.delegate.isAnnotationPresent(annotationType);
        }

        public <B> PersistentPropertyAccessor<B> getPropertyAccessor(B bean) {
            return this.delegate.getPropertyAccessor(bean);
        }

        public <B> PersistentPropertyPathAccessor<B> getPropertyPathAccessor(B bean) {
            return this.delegate.getPropertyPathAccessor(bean);
        }

        public IdentifierAccessor getIdentifierAccessor(Object bean) {
            return this.delegate.getIdentifierAccessor(bean);
        }

        public boolean isNew(Object bean) {
            return this.delegate.isNew(bean);
        }

        public boolean isImmutable() {
            return this.delegate.isImmutable();
        }

        public boolean requiresPropertyPopulation() {
            return this.delegate.requiresPropertyPopulation();
        }

        @NotNull
        public Iterator<CassandraPersistentProperty> iterator() {
            ArrayList target = new ArrayList();
            this.delegate.iterator().forEachRemaining(it -> target.add(this.wrap((CassandraPersistentProperty)it)));
            return target.iterator();
        }

        public void forEach(Consumer<? super CassandraPersistentProperty> action) {
            this.delegate.forEach(it -> action.accept(this.wrap((CassandraPersistentProperty)it)));
        }

        public Spliterator<CassandraPersistentProperty> spliterator() {
            return this.delegate.spliterator();
        }

        private PrefixedCassandraPersistentProperty wrap(CassandraPersistentProperty source) {
            return new PrefixedCassandraPersistentProperty(this.prefix, source);
        }
    }
}

