/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import org.springframework.lang.Nullable;

public class CassandraParameters
extends Parameters<CassandraParameters, CassandraParameter> {
    @Nullable
    private final Integer queryOptionsIndex;

    public CassandraParameters(Method method) {
        super(method);
        this.queryOptionsIndex = Arrays.asList(method.getParameterTypes()).indexOf(QueryOptions.class);
    }

    private CassandraParameters(List<CassandraParameter> originals, @Nullable Integer queryOptionsIndex) {
        super(originals);
        this.queryOptionsIndex = queryOptionsIndex;
    }

    protected CassandraParameter createParameter(MethodParameter parameter) {
        return new CassandraParameter(parameter);
    }

    protected CassandraParameters createFrom(List<CassandraParameter> parameters) {
        return new CassandraParameters(parameters, this.queryOptionsIndex);
    }

    public int getQueryOptionsIndex() {
        return this.queryOptionsIndex != null ? this.queryOptionsIndex : -1;
    }

    static class AnnotatedParameter
    implements AnnotatedElement {
        private final MethodParameter methodParameter;

        AnnotatedParameter(MethodParameter methodParameter) {
            this.methodParameter = methodParameter;
        }

        @Override
        @Nullable
        public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            return (T)this.methodParameter.getParameterAnnotation(annotationClass);
        }

        @Override
        public Annotation[] getAnnotations() {
            return this.methodParameter.getParameterAnnotations();
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.methodParameter.getParameterAnnotations();
        }
    }

    static class CassandraParameter
    extends Parameter {
        @Nullable
        private final CassandraType cassandraType;
        private final Class<?> parameterType;

        CassandraParameter(MethodParameter parameter) {
            super(parameter);
            AnnotatedParameter annotatedParameter = new AnnotatedParameter(parameter);
            this.cassandraType = AnnotatedElementUtils.hasAnnotation((AnnotatedElement)annotatedParameter, CassandraType.class) ? (CassandraType)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedParameter, CassandraType.class) : null;
            this.parameterType = CassandraParameter.potentiallyUnwrapParameterType(parameter);
        }

        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || QueryOptions.class.isAssignableFrom(this.getType());
        }

        @Nullable
        public CassandraType getCassandraType() {
            return this.cassandraType;
        }

        public Class<?> getType() {
            return this.parameterType;
        }

        private static Class<?> potentiallyUnwrapParameterType(MethodParameter parameter) {
            Class originalType = parameter.getParameterType();
            if (CassandraParameter.isWrapped(parameter) && CassandraParameter.shouldUnwrap(parameter)) {
                return ResolvableType.forMethodParameter((MethodParameter)parameter).getGeneric(new int[]{0}).getRawClass();
            }
            return originalType;
        }

        private static boolean isWrapped(MethodParameter parameter) {
            return QueryExecutionConverters.supports((Class)parameter.getParameterType()) || ReactiveWrapperConverters.supports((Class)parameter.getParameterType());
        }

        private static boolean shouldUnwrap(MethodParameter parameter) {
            return QueryExecutionConverters.supportsUnwrapping((Class)parameter.getParameterType()) || ReactiveWrappers.supports((Class)parameter.getParameterType());
        }
    }
}

