/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Tuple;
import org.springframework.data.mapping.MappingException;
import org.springframework.util.StringUtils;

enum CassandraPersistentTupleMetadataVerifier implements CassandraPersistentEntityMetadataVerifier
{
    INSTANCE;


    @Override
    public void verify(CassandraPersistentEntity<?> entity) throws MappingException {
        if (entity.getType().isInterface() || !entity.isAnnotationPresent(Tuple.class)) {
            return;
        }
        TreeSet<Integer> ordinals = new TreeSet<Integer>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty tupleProperty = (CassandraPersistentProperty)iterator.next();
            if (tupleProperty.isTransient() || ordinals.add(tupleProperty.getOrdinal())) continue;
            throw new MappingException(String.format("Duplicate ordinal [%d] in entity [%s]", tupleProperty.getOrdinal(), entity.getName()));
        }
        if (ordinals.isEmpty()) {
            throw new MappingException(String.format("Mapped tuple contains no persistent elements annotated with @Element in entity [%s]", entity.getName()));
        }
        List missingMappings = IntStream.range(0, ordinals.size()).boxed().collect(Collectors.toList());
        missingMappings.removeAll(ordinals);
        if (!missingMappings.isEmpty()) {
            throw new MappingException(String.format("Mapped tuple has no ordinal mapping in entity [%s] for ordinal(s): %s", entity.getName(), StringUtils.collectionToDelimitedString(missingMappings, (String)", ")));
        }
    }
}

