/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.cassandra.core.convert.CassandraConverters;
import org.springframework.data.cassandra.core.convert.CassandraJodaTimeConverters;
import org.springframework.data.cassandra.core.convert.CassandraJsr310Converters;
import org.springframework.data.cassandra.core.convert.CassandraThreeTenBackPortConverters;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public class CassandraCustomConversions
extends CustomConversions {
    private static final List<Object> STORE_CONVERTERS;
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;

    public CassandraCustomConversions(List<?> converters) {
        super((CustomConversions.ConverterConfiguration)new CassandraConverterConfiguration(STORE_CONVERSIONS, converters));
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(CassandraConverters.getConvertersToRegister());
        converters.addAll(CassandraJodaTimeConverters.getConvertersToRegister());
        converters.addAll(CassandraJsr310Converters.getConvertersToRegister());
        converters.addAll(CassandraThreeTenBackPortConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)CassandraSimpleTypeHolder.HOLDER, STORE_CONVERTERS);
    }

    static class CassandraConverterConfiguration
    extends CustomConversions.ConverterConfiguration {
        public CassandraConverterConfiguration(CustomConversions.StoreConversions storeConversions, List<?> userConverters) {
            super(storeConversions, userConverters, CassandraConverterConfiguration.getConverterFilter());
        }

        static Predicate<GenericConverter.ConvertiblePair> getConverterFilter() {
            return convertiblePair -> !CassandraConverterConfiguration.sourceMatches(convertiblePair, "org.joda.time") && !CassandraConverterConfiguration.sourceMatches(convertiblePair, "org.threeten.bp") && (!Jsr310Converters.supports((Class)convertiblePair.getSourceType()) || !Date.class.isAssignableFrom(convertiblePair.getTargetType()));
        }

        private static boolean sourceMatches(GenericConverter.ConvertiblePair convertiblePair, String packagePrefix) {
            return convertiblePair.getSourceType().getName().startsWith(packagePrefix);
        }
    }
}

