/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import java.util.function.UnaryOperator;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.SnakeCaseNamingStrategy;
import org.springframework.data.cassandra.core.mapping.TransformingNamingStrategy;
import org.springframework.util.Assert;

public interface NamingStrategy {
    public static final NamingStrategy INSTANCE = new NamingStrategy(){};
    public static final NamingStrategy SNAKE_CASE = new SnakeCaseNamingStrategy();

    default public String getTableName(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return entity.getType().getSimpleName();
    }

    default public String getUserDefinedTypeName(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return entity.getType().getSimpleName();
    }

    default public String getColumnName(CassandraPersistentProperty property) {
        Assert.notNull((Object)property, (String)"CassandraPersistentProperty must not be null");
        return property.getName();
    }

    default public NamingStrategy transform(UnaryOperator<String> mappingFunction) {
        Assert.notNull(mappingFunction, (String)"Mapping function must not be null");
        NamingStrategy previous = this;
        return new TransformingNamingStrategy(previous, mappingFunction);
    }
}

