/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.config.AbstractCassandraConfiguration;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.ReactiveCqlTemplate;
import org.springframework.data.cassandra.core.cql.session.DefaultBridgedReactiveSession;
import org.springframework.data.cassandra.core.cql.session.DefaultReactiveSessionFactory;
import org.springframework.lang.Nullable;

public abstract class AbstractReactiveCassandraConfiguration
extends AbstractCassandraConfiguration {
    @Nullable
    private BeanFactory beanFactory;

    @Bean
    public ReactiveSession reactiveCassandraSession() {
        return new DefaultBridgedReactiveSession(this.getRequiredSession());
    }

    @Bean
    public ReactiveSessionFactory reactiveCassandraSessionFactory() {
        return new DefaultReactiveSessionFactory((ReactiveSession)this.beanFactory.getBean(ReactiveSession.class));
    }

    @Bean
    public ReactiveCassandraTemplate reactiveCassandraTemplate() {
        return new ReactiveCassandraTemplate((ReactiveSessionFactory)this.beanFactory.getBean(ReactiveSessionFactory.class), (CassandraConverter)this.beanFactory.getBean(CassandraConverter.class));
    }

    @Bean
    public ReactiveCqlTemplate reactiveCqlTemplate() {
        return new ReactiveCqlTemplate((ReactiveSessionFactory)this.beanFactory.getBean(ReactiveSessionFactory.class));
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        super.setBeanFactory(beanFactory);
    }
}

