/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.oss.driver.api.core.CqlSession;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.CassandraPersistentEntitySchemaCreator;
import org.springframework.data.cassandra.core.CassandraPersistentEntitySchemaDropper;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.cql.session.init.KeyspacePopulator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SessionFactoryFactoryBean
extends AbstractFactoryBean<SessionFactory> {
    protected static final boolean DEFAULT_CREATE_IF_NOT_EXISTS = false;
    protected static final boolean DEFAULT_DROP_TABLES = false;
    protected static final boolean DEFAULT_DROP_UNUSED_TABLES = false;
    private CassandraConverter converter;
    private CqlSession session;
    @Nullable
    private KeyspacePopulator keyspaceCleaner;
    @Nullable
    private KeyspacePopulator keyspacePopulator;
    private SchemaAction schemaAction = SchemaAction.NONE;

    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
    }

    public void setKeyspaceCleaner(@Nullable KeyspacePopulator keyspaceCleaner) {
        this.keyspaceCleaner = keyspaceCleaner;
    }

    public void setKeyspacePopulator(@Nullable KeyspacePopulator keyspacePopulator) {
        this.keyspacePopulator = keyspacePopulator;
    }

    public void setSchemaAction(SchemaAction schemaAction) {
        Assert.notNull((Object)((Object)schemaAction), (String)"SchemaAction must not be null");
        this.schemaAction = schemaAction;
    }

    public void setSession(CqlSession session) {
        Assert.notNull((Object)session, (String)"Session must not be null");
        this.session = session;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.session != null ? 1 : 0) != 0, (String)"Session was not properly initialized");
        Assert.state((this.converter != null ? 1 : 0) != 0, (String)"Converter was not properly initialized");
        super.afterPropertiesSet();
        if (this.keyspacePopulator != null) {
            this.keyspacePopulator.populate(((SessionFactory)this.getObject()).getSession());
        }
        this.performSchemaAction();
        this.session.refreshSchema();
    }

    protected SessionFactory createInstance() {
        return new DefaultSessionFactory(this.session);
    }

    public void destroy() throws Exception {
        if (this.keyspaceCleaner != null) {
            this.keyspaceCleaner.populate(((SessionFactory)this.getObject()).getSession());
        }
    }

    @Nullable
    public Class<?> getObjectType() {
        return SessionFactory.class;
    }

    protected void performSchemaAction() throws Exception {
        boolean create = false;
        boolean drop = false;
        boolean dropUnused = false;
        boolean ifNotExists = false;
        switch (this.schemaAction) {
            case RECREATE_DROP_UNUSED: {
                dropUnused = true;
            }
            case RECREATE: {
                drop = true;
            }
            case CREATE_IF_NOT_EXISTS: {
                ifNotExists = SchemaAction.CREATE_IF_NOT_EXISTS.equals((Object)this.schemaAction);
            }
            case CREATE: {
                create = true;
            }
        }
        if (create) {
            this.createTables(drop, dropUnused, ifNotExists);
        }
    }

    protected void createTables(boolean drop, boolean dropUnused, boolean ifNotExists) throws Exception {
        this.performSchemaActions(drop, dropUnused, ifNotExists);
    }

    private void performSchemaActions(boolean drop, boolean dropUnused, boolean ifNotExists) throws Exception {
        CassandraAdminTemplate adminOperations = new CassandraAdminTemplate((SessionFactory)this.getObject(), this.converter);
        CassandraPersistentEntitySchemaCreator schemaCreator = new CassandraPersistentEntitySchemaCreator(this.converter.getMappingContext(), adminOperations);
        if (drop) {
            CassandraPersistentEntitySchemaDropper schemaDropper = new CassandraPersistentEntitySchemaDropper(this.converter.getMappingContext(), adminOperations);
            schemaDropper.dropTables(dropUnused);
            schemaDropper.dropUserTypes(dropUnused);
        }
        schemaCreator.createUserTypes(ifNotExists);
        schemaCreator.createTables(ifNotExists);
        schemaCreator.createIndexes(ifNotExists);
    }
}

