/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql.keyspace;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.cassandra.core.cql.KeyspaceIdentifier;
import org.springframework.data.cassandra.core.cql.keyspace.CqlStringUtils;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceActionSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.KeyspaceOption;
import org.springframework.lang.Nullable;

public abstract class KeyspaceOptionsSpecification<T extends KeyspaceOptionsSpecification<T>>
extends KeyspaceActionSpecification {
    protected Map<String, Object> options = new LinkedHashMap<String, Object>();

    protected KeyspaceOptionsSpecification(KeyspaceIdentifier name) {
        super(name);
    }

    public T with(KeyspaceOption option) {
        return this.with(option.getName(), null, option.escapesValue(), option.quotesValue());
    }

    public T with(KeyspaceOption option, Object value) {
        option.checkValue(value);
        return this.with(option.getName(), value, option.escapesValue(), option.quotesValue());
    }

    public T with(String name, @Nullable Object value, boolean escape, boolean quote) {
        if (!(value instanceof Map)) {
            if (escape) {
                value = CqlStringUtils.escapeSingle(value);
            }
            if (quote) {
                value = CqlStringUtils.singleQuote(value);
            }
        }
        this.options.put(name, value);
        return (T)this;
    }

    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyspaceOptionsSpecification)) {
            return false;
        }
        KeyspaceOptionsSpecification other = (KeyspaceOptionsSpecification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$options = this.getOptions();
        Map<String, Object> other$options = other.getOptions();
        return !(this$options == null ? other$options != null : !((Object)this$options).equals(other$options));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KeyspaceOptionsSpecification;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        return result;
    }
}

