/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import java.util.Arrays;
import java.util.Iterator;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.DefaultFilter;
import org.springframework.util.Assert;

@FunctionalInterface
public interface Filter
extends Iterable<CriteriaDefinition> {
    public Iterable<CriteriaDefinition> getCriteriaDefinitions();

    public static Filter from(CriteriaDefinition ... criteriaDefinitions) {
        Assert.notNull((Object)criteriaDefinitions, (String)"CriteriaDefinitions must not be null");
        return Filter.from(Arrays.asList(criteriaDefinitions));
    }

    public static Filter from(Iterable<? extends CriteriaDefinition> criteriaDefinitions) {
        Assert.notNull(criteriaDefinitions, (String)"CriteriaDefinitions must not be null");
        return new DefaultFilter(criteriaDefinitions);
    }

    @Override
    default public Iterator<CriteriaDefinition> iterator() {
        return this.getCriteriaDefinitions().iterator();
    }
}

