/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.Map;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.ClassUtils;

class CassandraReturnedType {
    private final ReturnedType returnedType;
    private final CustomConversions customConversions;

    CassandraReturnedType(ReturnedType returnedType, CustomConversions customConversions) {
        this.returnedType = returnedType;
        this.customConversions = customConversions;
    }

    boolean isProjecting() {
        if (!this.returnedType.isProjecting()) {
            return false;
        }
        if (ClassUtils.isAssignable(Map.class, (Class)this.returnedType.getReturnedType())) {
            return false;
        }
        if (this.customConversions.hasCustomWriteTarget(this.returnedType.getReturnedType())) {
            return false;
        }
        return !this.customConversions.isSimpleType(this.returnedType.getReturnedType());
    }

    Class<?> getDomainType() {
        return this.returnedType.getDomainType();
    }

    Class<?> getReturnedType() {
        return this.returnedType.getReturnedType();
    }
}

