/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UserType;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.util.Assert;

class UserTypeUtil {
    UserTypeUtil() {
    }

    static DataType potentiallyFreeze(DataType dataType) {
        DataType.CollectionType collectionType;
        DataType typeArgument;
        Assert.notNull((Object)dataType, (String)"DataType must not be null");
        if (dataType.getName() == DataType.Name.LIST && dataType instanceof DataType.CollectionType && ((typeArgument = (DataType)(collectionType = (DataType.CollectionType)dataType).getTypeArguments().get(0)) instanceof DataType.CollectionType || UserTypeUtil.isNonFrozenUdt(typeArgument))) {
            return DataType.list((DataType)UserTypeUtil.potentiallyFreeze(typeArgument), (boolean)collectionType.isFrozen());
        }
        if (dataType.getName() == DataType.Name.SET && dataType instanceof DataType.CollectionType && ((typeArgument = (DataType)(collectionType = (DataType.CollectionType)dataType).getTypeArguments().get(0)) instanceof DataType.CollectionType || UserTypeUtil.isNonFrozenUdt(typeArgument))) {
            return DataType.set((DataType)UserTypeUtil.potentiallyFreeze(typeArgument), (boolean)collectionType.isFrozen());
        }
        if (dataType.getName() == DataType.Name.MAP && dataType instanceof DataType.CollectionType) {
            collectionType = (DataType.CollectionType)dataType;
            DataType keyType = (DataType)collectionType.getTypeArguments().get(0);
            DataType valueType = (DataType)collectionType.getTypeArguments().get(1);
            if (keyType instanceof DataType.CollectionType || valueType instanceof DataType.CollectionType || UserTypeUtil.isNonFrozenUdt(keyType) || UserTypeUtil.isNonFrozenUdt(valueType)) {
                return DataType.map((DataType)UserTypeUtil.potentiallyFreeze(keyType), (DataType)UserTypeUtil.potentiallyFreeze(valueType), (boolean)collectionType.isFrozen());
            }
        }
        return UserTypeUtil.isNonFrozenUdt(dataType) ? new FrozenLiteralDataType(UserTypeUtil.getTypeName(dataType)) : dataType;
    }

    private static CqlIdentifier getTypeName(DataType dataType) {
        if (dataType instanceof UserType) {
            return CqlIdentifier.of(((UserType)dataType).getTypeName());
        }
        return CqlIdentifier.of(dataType.asFunctionParameterString());
    }

    private static boolean isNonFrozenUdt(DataType dataType) {
        return dataType.getName() == DataType.Name.UDT && !dataType.isFrozen();
    }

    static class FrozenLiteralDataType
    extends DataType {
        private final CqlIdentifier type;

        FrozenLiteralDataType(CqlIdentifier type) {
            super(DataType.Name.UDT);
            this.type = type;
        }

        public boolean isFrozen() {
            return true;
        }

        public String toString() {
            return String.format("frozen<%s>", this.type.toCql());
        }
    }
}

