/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.UDTValue;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.springframework.lang.Nullable;

public abstract class RowUtils {
    private RowUtils() {
    }

    @Nullable
    public static Object getRowValue(Row row, int index, @Nullable Class<?> requiredType) {
        Comparable<Boolean> value;
        if (requiredType == null) {
            return row.getObject(index);
        }
        if (String.class == requiredType) {
            return row.getString(index);
        }
        if (Boolean.TYPE == requiredType || Boolean.class == requiredType) {
            value = row.getBool(index);
        } else if (Byte.TYPE == requiredType || Byte.class == requiredType) {
            value = row.getByte(index);
        } else if (Short.TYPE == requiredType || Short.class == requiredType) {
            value = row.getShort(index);
        } else if (Integer.TYPE == requiredType || Integer.class == requiredType) {
            value = row.getInt(index);
        } else if (Long.TYPE == requiredType || Long.class == requiredType) {
            value = row.getLong(index);
        } else if (Float.TYPE == requiredType || Float.class == requiredType) {
            value = Float.valueOf(row.getFloat(index));
        } else if (Double.TYPE == requiredType || Double.class == requiredType || Number.class == requiredType) {
            value = row.getDouble(index);
        } else {
            if (BigDecimal.class == requiredType) {
                return row.getDecimal(index);
            }
            if (LocalDate.class == requiredType) {
                return row.getDate(index);
            }
            if (Date.class == requiredType) {
                return row.getTimestamp(index);
            }
            if (ByteBuffer.class == requiredType) {
                return row.getBytes(index);
            }
            if (TupleValue.class == requiredType) {
                return row.getTupleValue(index);
            }
            if (UDTValue.class == requiredType) {
                return row.getUDTValue(index);
            }
            if (UUID.class == requiredType) {
                return row.getUUID(index);
            }
            return row.getObject(index);
        }
        return row.isNull(index) ? null : value;
    }
}

