/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Truncate;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.dao.DataAccessException;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.core.AsyncCassandraOperations;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.QueryUtils;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.UpdateOptions;
import org.springframework.data.cassandra.core.WriteResult;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.convert.QueryMapper;
import org.springframework.data.cassandra.core.convert.UpdateMapper;
import org.springframework.data.cassandra.core.cql.AsyncCqlOperations;
import org.springframework.data.cassandra.core.cql.AsyncCqlTemplate;
import org.springframework.data.cassandra.core.cql.AsyncSessionCallback;
import org.springframework.data.cassandra.core.cql.CassandraAccessor;
import org.springframework.data.cassandra.core.cql.CqlExceptionTranslator;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.CqlProvider;
import org.springframework.data.cassandra.core.cql.GuavaListenableFutureAdapter;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.query.Query;
import org.springframework.data.cassandra.core.query.Update;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.domain.Slice;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureAdapter;

public class AsyncCassandraTemplate
implements AsyncCassandraOperations {
    private final AsyncCqlOperations cqlOperations;
    private final CassandraConverter converter;
    private final MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext;
    private final CqlExceptionTranslator exceptionTranslator;
    private final StatementFactory statementFactory;

    public AsyncCassandraTemplate(Session session) {
        this(session, (CassandraConverter)AsyncCassandraTemplate.newConverter());
    }

    public AsyncCassandraTemplate(Session session, CassandraConverter converter) {
        this(new DefaultSessionFactory(session), converter);
    }

    public AsyncCassandraTemplate(SessionFactory sessionFactory, CassandraConverter converter) {
        this(new AsyncCqlTemplate(sessionFactory), converter);
    }

    public AsyncCassandraTemplate(AsyncCqlTemplate asyncCqlTemplate, CassandraConverter converter) {
        Assert.notNull((Object)asyncCqlTemplate, (String)"AsyncCqlTemplate must not be null");
        Assert.notNull((Object)converter, (String)"CassandraConverter must not be null");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.cqlOperations = asyncCqlTemplate;
        this.exceptionTranslator = asyncCqlTemplate.getExceptionTranslator();
        this.statementFactory = new StatementFactory(new QueryMapper(converter), new UpdateMapper(converter));
    }

    @Override
    public AsyncCqlOperations getAsyncCqlOperations() {
        return this.cqlOperations;
    }

    @Override
    public CassandraConverter getConverter() {
        return this.converter;
    }

    private static MappingCassandraConverter newConverter() {
        MappingCassandraConverter converter = new MappingCassandraConverter();
        converter.afterPropertiesSet();
        return converter;
    }

    protected MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    protected StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    private CqlIdentifier getTableName(Object entity) {
        return ((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(ClassUtils.getUserClass((Object)entity))).getTableName();
    }

    @Override
    public <T> ListenableFuture<List<T>> select(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        return this.select((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> ListenableFuture<Void> select(String cql, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)new SimpleStatement(cql), entityConsumer, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> selectOne(String cql, Class<T> entityClass) {
        Assert.hasText((String)cql, (String)"Statement must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)new SimpleStatement(cql), entityClass);
    }

    @Override
    public <T> ListenableFuture<List<T>> select(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getAsyncCqlOperations().query(statement, (row, rowNum) -> this.getConverter().read(entityClass, row));
    }

    @Override
    public <T> ListenableFuture<Slice<T>> slice(Statement statement, Class<T> entityClass) {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        ListenableFuture<ResultSet> resultSet = this.getAsyncCqlOperations().queryForResultSet(statement);
        CassandraConverter converter = this.getConverter();
        return new MappingListenableFutureAdapter<Slice, ResultSet>(resultSet, rs -> QueryUtils.readSlice(rs, (row, rowNum) -> converter.read(entityClass, row), 0, this.getEffectiveFetchSize(statement)));
    }

    @Override
    public <T> ListenableFuture<Void> select(Statement statement, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)statement, (String)"Statement must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getAsyncCqlOperations().query(statement, row -> entityConsumer.accept(this.getConverter().read(entityClass, row)));
    }

    @Override
    public <T> ListenableFuture<T> selectOne(Statement statement, Class<T> entityClass) {
        return new MappingListenableFutureAdapter<Object, List>(this.select(statement, entityClass), list -> list.stream().findFirst().orElse(null));
    }

    @Override
    public <T> ListenableFuture<List<T>> select(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)this.getStatementFactory().select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> ListenableFuture<Slice<T>> slice(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.slice((Statement)this.statementFactory.select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public <T> ListenableFuture<Void> select(Query query, Consumer<T> entityConsumer, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityConsumer, (String)"Entity Consumer must not be empty");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.select((Statement)this.getStatementFactory().select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityConsumer, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> selectOne(Query query, Class<T> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.selectOne((Statement)this.getStatementFactory().select(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)), entityClass);
    }

    @Override
    public ListenableFuture<Boolean> update(Query query, Update update, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getAsyncCqlOperations().execute((Statement)this.getStatementFactory().update(query, update, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)));
    }

    @Override
    public ListenableFuture<Boolean> delete(Query query, Class<?> entityClass) throws DataAccessException {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        return this.getAsyncCqlOperations().execute((Statement)this.getStatementFactory().delete(query, (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)));
    }

    @Override
    public ListenableFuture<Long> count(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Select select = QueryBuilder.select().countAll().from(((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)).getTableName().toCql());
        return this.getAsyncCqlOperations().queryForObject((Statement)select, Long.class);
    }

    @Override
    public ListenableFuture<Boolean> exists(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Select select = QueryBuilder.select().from(entity.getTableName().toCql());
        this.getConverter().write(id, select.where(), entity);
        return new MappingListenableFutureAdapter<Boolean, ResultSet>(this.getAsyncCqlOperations().queryForResultSet((Statement)select), resultSet -> resultSet.iterator().hasNext());
    }

    @Override
    public <T> ListenableFuture<T> selectOneById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Select select = QueryBuilder.select().all().from(entity.getTableName().toCql());
        this.getConverter().write(id, select.where(), entity);
        return this.selectOne((Statement)select, entityClass);
    }

    @Override
    public <T> ListenableFuture<T> insert(T entity) {
        return new MappingListenableFutureAdapter<Object, WriteResult>(this.insert(entity, InsertOptions.empty()), writeResult -> entity);
    }

    @Override
    public ListenableFuture<WriteResult> insert(Object entity, InsertOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"InsertOptions must not be null");
        Insert insert = QueryUtils.createInsertQuery(this.getTableName(entity).toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        return new MappingListenableFutureAdapter<WriteResult, ResultSet>(this.getAsyncCqlOperations().execute(new AsyncStatementCallback((Statement)insert)), WriteResult::of);
    }

    @Override
    public <T> ListenableFuture<T> update(T entity) {
        return new MappingListenableFutureAdapter<Object, WriteResult>(this.update(entity, UpdateOptions.empty()), writeResult -> entity);
    }

    @Override
    public ListenableFuture<WriteResult> update(Object entity, UpdateOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"UpdateOptions must not be null");
        com.datastax.driver.core.querybuilder.Update update = QueryUtils.createUpdateQuery(this.getTableName(entity).toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        return new MappingListenableFutureAdapter<WriteResult, ResultSet>(this.getAsyncCqlOperations().execute(new AsyncStatementCallback((Statement)update)), WriteResult::of);
    }

    @Override
    public <T> ListenableFuture<T> delete(T entity) {
        return new MappingListenableFutureAdapter<Object, WriteResult>(this.delete(entity, QueryOptions.empty()), writeResult -> entity);
    }

    @Override
    public ListenableFuture<WriteResult> delete(Object entity, QueryOptions options) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        Assert.notNull((Object)options, (String)"QueryOptions must not be null");
        Delete delete = QueryUtils.createDeleteQuery(this.getTableName(entity).toCql(), entity, options, (EntityWriter<Object, Object>)this.getConverter());
        return new MappingListenableFutureAdapter<WriteResult, ResultSet>(this.getAsyncCqlOperations().execute(new AsyncStatementCallback((Statement)delete)), WriteResult::of);
    }

    @Override
    public ListenableFuture<Boolean> deleteById(Object id, Class<?> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null");
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass);
        Delete delete = QueryBuilder.delete().from(entity.getTableName().toCql());
        this.getConverter().write(id, delete.where(), entity);
        return this.getAsyncCqlOperations().execute((Statement)delete);
    }

    @Override
    public ListenableFuture<Void> truncate(Class<?> entityClass) {
        Assert.notNull(entityClass, (String)"Entity type must not be null");
        Truncate truncate = QueryBuilder.truncate((String)((CassandraPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(entityClass)).getTableName().toCql());
        return new MappingListenableFutureAdapter<Void, Boolean>(this.getAsyncCqlOperations().execute((Statement)truncate), aBoolean -> null);
    }

    private int getEffectiveFetchSize(Statement statement) {
        CassandraAccessor accessor;
        if (statement.getFetchSize() > 0) {
            return statement.getFetchSize();
        }
        if (this.getAsyncCqlOperations() instanceof CassandraAccessor && (accessor = (CassandraAccessor)((Object)this.getAsyncCqlOperations())).getFetchSize() != -1) {
            return accessor.getFetchSize();
        }
        return (Integer)this.getAsyncCqlOperations().execute(session -> AsyncResult.forValue((Object)session.getCluster().getConfiguration().getQueryOptions().getFetchSize())).completable().join();
    }

    private class AsyncStatementCallback
    implements AsyncSessionCallback<ResultSet>,
    CqlProvider {
        private final Statement statement;

        AsyncStatementCallback(Statement statement) {
            this.statement = statement;
        }

        @Override
        public ListenableFuture<ResultSet> doInSession(Session session) throws DriverException, DataAccessException {
            return new GuavaListenableFutureAdapter<ResultSet>((com.google.common.util.concurrent.ListenableFuture<ResultSet>)session.executeAsync(this.statement), e -> e instanceof DriverException ? AsyncCassandraTemplate.this.exceptionTranslator.translate("AsyncStatementCallback", this.getCql(), (DriverException)e) : AsyncCassandraTemplate.this.exceptionTranslator.translateExceptionIfPossible(e));
        }

        @Override
        public String getCql() {
            return this.statement.toString();
        }
    }

    static class MappingListenableFutureAdapter<T, S>
    extends ListenableFutureAdapter<T, S> {
        private final Function<S, T> mapper;

        MappingListenableFutureAdapter(ListenableFuture<S> adaptee, Function<S, T> mapper) {
            super(adaptee);
            this.mapper = mapper;
        }

        protected T adapt(@Nullable S adapteeResult) throws ExecutionException {
            return this.mapper.apply(adapteeResult);
        }
    }
}

