/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.context.annotation.Bean;
import org.springframework.data.cassandra.ReactiveSession;
import org.springframework.data.cassandra.ReactiveSessionFactory;
import org.springframework.data.cassandra.config.AbstractCassandraConfiguration;
import org.springframework.data.cassandra.core.ReactiveCassandraOperations;
import org.springframework.data.cassandra.core.ReactiveCassandraTemplate;
import org.springframework.data.cassandra.core.cql.ReactiveCqlOperations;
import org.springframework.data.cassandra.core.cql.ReactiveCqlTemplate;
import org.springframework.data.cassandra.core.cql.session.DefaultBridgedReactiveSession;
import org.springframework.data.cassandra.core.cql.session.DefaultReactiveSessionFactory;

public abstract class AbstractReactiveCassandraConfiguration
extends AbstractCassandraConfiguration {
    @Bean
    public ReactiveSession reactiveSession() {
        return new DefaultBridgedReactiveSession(this.getRequiredSession());
    }

    @Bean
    public ReactiveSessionFactory reactiveSessionFactory() {
        return new DefaultReactiveSessionFactory(this.reactiveSession());
    }

    @Bean
    public ReactiveCassandraOperations reactiveCassandraTemplate() {
        return new ReactiveCassandraTemplate(this.reactiveSessionFactory(), this.cassandraConverter());
    }

    @Bean
    public ReactiveCqlOperations reactiveCqlTemplate() {
        return new ReactiveCqlTemplate(this.reactiveSessionFactory());
    }
}

