/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import com.datastax.driver.core.AbstractTableMetadata;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;

public class CassandraPersistentEntitySchemaDropper {
    private final CassandraAdminOperations cassandraAdminOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraPersistentEntitySchemaDropper(CassandraMappingContext mappingContext, CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = mappingContext;
    }

    public void dropTables(boolean dropUnused) {
        this.cassandraAdminOperations.getKeyspaceMetadata().getTables().stream().map(AbstractTableMetadata::getName).map(CqlIdentifier::of).filter(table -> dropUnused || this.mappingContext.usesTable((CqlIdentifier)table)).forEach(this.cassandraAdminOperations::dropTable);
    }

    public void dropUserTypes(boolean dropUnused) {
        Set canRecreate = this.mappingContext.getUserDefinedTypeEntities().stream().map(CassandraPersistentEntity::getTableName).collect(Collectors.toSet());
        this.cassandraAdminOperations.getKeyspaceMetadata().getUserTypes().forEach(userType -> {
            CqlIdentifier typeName = CqlIdentifier.of(userType.getTypeName());
            if (canRecreate.contains(typeName)) {
                this.cassandraAdminOperations.dropUserType(typeName);
            } else if (dropUnused && !this.mappingContext.usesUserType(typeName)) {
                this.cassandraAdminOperations.dropUserType(typeName);
            }
        });
    }
}

