/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.cql;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.policies.RetryPolicy;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class QueryOptions {
    private static final QueryOptions EMPTY = QueryOptions.builder().build();
    @Nullable
    private final Boolean tracing;
    @Nullable
    private final ConsistencyLevel consistencyLevel;
    private final Duration readTimeout;
    @Nullable
    private final Integer fetchSize;
    @Nullable
    private final RetryPolicy retryPolicy;

    protected QueryOptions(@Nullable ConsistencyLevel consistencyLevel, @Nullable RetryPolicy retryPolicy, @Nullable Boolean tracing, @Nullable Integer fetchSize, Duration readTimeout) {
        this.consistencyLevel = consistencyLevel;
        this.retryPolicy = retryPolicy;
        this.tracing = tracing;
        this.fetchSize = fetchSize;
        this.readTimeout = readTimeout;
    }

    @Deprecated
    public QueryOptions(@Nullable ConsistencyLevel consistencyLevel, @Nullable RetryPolicy retryPolicy) {
        this.consistencyLevel = consistencyLevel;
        this.retryPolicy = retryPolicy;
        this.tracing = false;
        this.fetchSize = null;
        this.readTimeout = Duration.ofMillis(-1L);
    }

    public static QueryOptionsBuilder builder() {
        return new QueryOptionsBuilder();
    }

    public static QueryOptions empty() {
        return EMPTY;
    }

    public QueryOptionsBuilder mutate() {
        return new QueryOptionsBuilder(this);
    }

    @Nullable
    protected ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    @Nullable
    protected Integer getFetchSize() {
        return this.fetchSize;
    }

    protected Duration getReadTimeout() {
        return this.readTimeout;
    }

    @Nullable
    protected RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Nullable
    protected Boolean getTracing() {
        return this.tracing;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryOptions)) {
            return false;
        }
        QueryOptions other = (QueryOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$tracing = this.getTracing();
        Boolean other$tracing = other.getTracing();
        if (this$tracing == null ? other$tracing != null : !((Object)this$tracing).equals(other$tracing)) {
            return false;
        }
        ConsistencyLevel this$consistencyLevel = this.getConsistencyLevel();
        ConsistencyLevel other$consistencyLevel = other.getConsistencyLevel();
        if (this$consistencyLevel == null ? other$consistencyLevel != null : !this$consistencyLevel.equals(other$consistencyLevel)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Integer this$fetchSize = this.getFetchSize();
        Integer other$fetchSize = other.getFetchSize();
        if (this$fetchSize == null ? other$fetchSize != null : !((Object)this$fetchSize).equals(other$fetchSize)) {
            return false;
        }
        RetryPolicy this$retryPolicy = this.getRetryPolicy();
        RetryPolicy other$retryPolicy = other.getRetryPolicy();
        return !(this$retryPolicy == null ? other$retryPolicy != null : !this$retryPolicy.equals(other$retryPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $tracing = this.getTracing();
        result = result * 59 + ($tracing == null ? 43 : ((Object)$tracing).hashCode());
        ConsistencyLevel $consistencyLevel = this.getConsistencyLevel();
        result = result * 59 + ($consistencyLevel == null ? 43 : $consistencyLevel.hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Integer $fetchSize = this.getFetchSize();
        result = result * 59 + ($fetchSize == null ? 43 : ((Object)$fetchSize).hashCode());
        RetryPolicy $retryPolicy = this.getRetryPolicy();
        result = result * 59 + ($retryPolicy == null ? 43 : $retryPolicy.hashCode());
        return result;
    }

    public static class QueryOptionsBuilder {
        @Nullable
        protected Boolean tracing;
        @Nullable
        protected ConsistencyLevel consistencyLevel;
        protected Duration readTimeout = Duration.ofMillis(-1L);
        @Nullable
        protected Integer fetchSize;
        @Nullable
        protected RetryPolicy retryPolicy;

        QueryOptionsBuilder() {
        }

        QueryOptionsBuilder(QueryOptions queryOptions) {
            this.consistencyLevel = queryOptions.consistencyLevel;
            this.fetchSize = queryOptions.fetchSize;
            this.readTimeout = queryOptions.readTimeout;
            this.retryPolicy = queryOptions.retryPolicy;
            this.tracing = queryOptions.tracing;
        }

        public QueryOptionsBuilder consistencyLevel(ConsistencyLevel consistencyLevel) {
            Assert.notNull((Object)consistencyLevel, (String)"ConsistencyLevel must not be null");
            this.consistencyLevel = consistencyLevel;
            return this;
        }

        public QueryOptionsBuilder retryPolicy(RetryPolicy retryPolicy) {
            Assert.notNull((Object)retryPolicy, (String)"RetryPolicy must not be null");
            this.retryPolicy = retryPolicy;
            return this;
        }

        public QueryOptionsBuilder fetchSize(int fetchSize) {
            Assert.isTrue((fetchSize >= 0 ? 1 : 0) != 0, (String)"FetchSize must be greater than equal to zero");
            this.fetchSize = fetchSize;
            return this;
        }

        public QueryOptionsBuilder readTimeout(long readTimeout) {
            return this.readTimeout(Duration.ofMillis(readTimeout));
        }

        @Deprecated
        public QueryOptionsBuilder readTimeout(long readTimeout, TimeUnit timeUnit) {
            Assert.isTrue((readTimeout >= 0L ? 1 : 0) != 0, (String)"ReadTimeout must be greater than equal to zero");
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            return this.readTimeout(Duration.ofMillis(timeUnit.toMillis(readTimeout)));
        }

        public QueryOptionsBuilder readTimeout(Duration readTimeout) {
            Assert.isTrue((!readTimeout.isZero() && !readTimeout.isNegative() ? 1 : 0) != 0, (String)"ReadTimeout must be greater than equal to zero");
            this.readTimeout = readTimeout;
            return this;
        }

        public QueryOptionsBuilder tracing(boolean tracing) {
            this.tracing = tracing;
            return this;
        }

        public QueryOptionsBuilder withTracing() {
            return this.tracing(true);
        }

        public QueryOptions build() {
            return new QueryOptions(this.consistencyLevel, this.retryPolicy, this.tracing, this.fetchSize, this.readTimeout);
        }
    }
}

