/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.query;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.TypeCodec;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.cassandra.core.query.ColumnName;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.lang.Nullable;

abstract class SerializationUtils {
    private SerializationUtils() {
    }

    @Nullable
    public static String serializeToCqlSafely(@Nullable CriteriaDefinition criteria) {
        if (criteria == null) {
            return null;
        }
        CriteriaDefinition.Predicate predicate = criteria.getPredicate();
        return SerializationUtils.serialize(criteria.getColumnName(), predicate.getOperator()).append(SerializationUtils.serializeToCqlSafely(predicate.getValue())).toString();
    }

    @Nullable
    public static String serializeToCqlSafely(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        try {
            return SerializationUtils.serialize(value);
        }
        catch (Exception e) {
            if (value instanceof Set) {
                return SerializationUtils.toString((Set)value);
            }
            if (value instanceof Collection) {
                return SerializationUtils.toString((Collection)value);
            }
            if (value instanceof Map) {
                return SerializationUtils.toString((Map)value);
            }
            return value.toString();
        }
    }

    private static String serialize(@Nullable Object value) {
        if (value == null) {
            return "null";
        }
        TypeCodec codec = CodecRegistry.DEFAULT_INSTANCE.codecFor(value);
        return codec.format(value);
    }

    private static StringBuilder serialize(ColumnName key, CriteriaDefinition.Operator operator) {
        StringBuilder builder = new StringBuilder(16);
        return builder.append(key).append(' ').append(operator).append(' ');
    }

    private static String toString(Map<?, ?> source) {
        return SerializationUtils.iterableToDelimitedString(source.entrySet(), "{ ", " }", s -> String.format("%s : %s", SerializationUtils.serialize(s.getKey()), SerializationUtils.serialize(s.getValue())));
    }

    private static String toString(Set<?> source) {
        return SerializationUtils.iterableToDelimitedString(source, "{", "}", SerializationUtils::serializeToCqlSafely);
    }

    private static String toString(Collection<?> source) {
        return SerializationUtils.iterableToDelimitedString(source, "[", "]", SerializationUtils::serializeToCqlSafely);
    }

    private static <T> String iterableToDelimitedString(Iterable<T> source, String prefix, String postfix, Converter<? super T, Object> transformer) {
        StringBuilder builder = new StringBuilder(prefix);
        Iterator<T> iterator = source.iterator();
        while (iterator.hasNext()) {
            builder.append(transformer.convert(iterator.next()));
            if (!iterator.hasNext()) continue;
            builder.append(",");
        }
        return builder.append(postfix).toString();
    }
}

