/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.generator.CreateIndexCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateTableCqlGenerator;
import org.springframework.data.cassandra.core.cql.generator.CreateUserTypeCqlGenerator;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateUserTypeSpecification;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.util.Assert;

public class CassandraPersistentEntitySchemaCreator {
    private final CassandraAdminOperations cassandraAdminOperations;
    private final CassandraMappingContext mappingContext;

    public CassandraPersistentEntitySchemaCreator(CassandraMappingContext mappingContext, CassandraAdminOperations cassandraAdminOperations) {
        Assert.notNull((Object)cassandraAdminOperations, (String)"CassandraAdminOperations must not be null");
        Assert.notNull((Object)((Object)mappingContext), (String)"CassandraMappingContext must not be null");
        this.cassandraAdminOperations = cassandraAdminOperations;
        this.mappingContext = mappingContext;
    }

    public void createTables(boolean ifNotExists) {
        this.createTableSpecifications(ifNotExists).stream().map(CreateTableCqlGenerator::toCql).forEach(cql -> this.cassandraAdminOperations.getCqlOperations().execute((String)cql));
    }

    protected List<CreateTableSpecification> createTableSpecifications(boolean ifNotExists) {
        return this.mappingContext.getTableEntities().stream().map(entity -> this.mappingContext.getCreateTableSpecificationFor((CassandraPersistentEntity<?>)entity).ifNotExists(ifNotExists)).collect(Collectors.toList());
    }

    public void createIndexes(boolean ifNotExists) {
        this.createIndexSpecifications(ifNotExists).stream().map(CreateIndexCqlGenerator::toCql).forEach(cql -> this.cassandraAdminOperations.getCqlOperations().execute((String)cql));
    }

    protected List<CreateIndexSpecification> createIndexSpecifications(boolean ifNotExists) {
        return this.mappingContext.getTableEntities().stream().flatMap(entity -> this.mappingContext.getCreateIndexSpecificationsFor((CassandraPersistentEntity<?>)entity).stream()).peek(it -> it.ifNotExists(ifNotExists)).collect(Collectors.toList());
    }

    public void createUserTypes(boolean ifNotExists) {
        this.createUserTypeSpecifications(ifNotExists).stream().map(CreateUserTypeCqlGenerator::toCql).forEach(cql -> this.cassandraAdminOperations.getCqlOperations().execute((String)cql));
    }

    protected List<CreateUserTypeSpecification> createUserTypeSpecifications(boolean ifNotExists) {
        ArrayList entities = new ArrayList(this.mappingContext.getUserDefinedTypeEntities());
        Map<CqlIdentifier, CassandraPersistentEntity> byTableName = entities.stream().collect(Collectors.toMap(CassandraPersistentEntity::getTableName, entity -> entity));
        ArrayList<CreateUserTypeSpecification> specifications = new ArrayList<CreateUserTypeSpecification>();
        HashSet created = new HashSet();
        entities.forEach(entity -> {
            LinkedHashSet<CqlIdentifier> seen = new LinkedHashSet<CqlIdentifier>();
            seen.add(entity.getTableName());
            this.visitUserTypes((CassandraPersistentEntity<?>)entity, (Set<CqlIdentifier>)seen);
            ArrayList<CqlIdentifier> ordered = new ArrayList<CqlIdentifier>(seen);
            Collections.reverse(ordered);
            specifications.addAll(ordered.stream().filter(created::add).map(identifier -> this.mappingContext.getCreateUserTypeSpecificationFor((CassandraPersistentEntity)byTableName.get(identifier)).ifNotExists(ifNotExists)).collect(Collectors.toList()));
        });
        return specifications;
    }

    private void visitUserTypes(CassandraPersistentEntity<?> entity, Set<CqlIdentifier> seen) {
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)this.mappingContext.getPersistentEntity(property);
            if (persistentEntity == null || !persistentEntity.isUserDefinedType() || !seen.add(persistentEntity.getTableName())) continue;
            this.visitUserTypes(persistentEntity, seen);
        }
    }
}

