/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.lang.Nullable;

public class CassandraSimpleTypeHolder
extends SimpleTypeHolder {
    public static final Set<Class<?>> CASSANDRA_SIMPLE_TYPES;
    private static final Map<Class<?>, DataType> classToDataType;
    private static final Map<DataType.Name, DataType> nameToDataType;
    public static final SimpleTypeHolder HOLDER;

    private CassandraSimpleTypeHolder() {
        super(CASSANDRA_SIMPLE_TYPES, true);
    }

    private static Map<DataType.Name, DataType> nameToDataType() {
        HashMap<DataType.Name, DataType> nameToDataType = new HashMap<DataType.Name, DataType>(16);
        DataType.allPrimitiveTypes().forEach(dataType -> nameToDataType.put(dataType.getName(), (DataType)dataType));
        nameToDataType.put(DataType.Name.VARCHAR, DataType.varchar());
        nameToDataType.put(DataType.Name.TEXT, DataType.text());
        return nameToDataType;
    }

    private static Map<Class<?>, DataType> classToDataType(CodecRegistry codecRegistry, Map<Class<?>, Class<?>> primitiveWrappers) {
        HashMap classToDataType = new HashMap(16);
        DataType.allPrimitiveTypes().forEach(dataType -> {
            Class javaType = codecRegistry.codecFor(dataType).getJavaType().getRawType();
            classToDataType.put(javaType, (DataType)dataType);
            Optional.ofNullable(primitiveWrappers.get(javaType)).ifPresent(primitiveType -> classToDataType.put((Class<?>)primitiveType, (DataType)dataType));
        });
        classToDataType.put(String.class, DataType.text());
        classToDataType.put(Long.class, DataType.bigint());
        classToDataType.put(Long.TYPE, DataType.bigint());
        classToDataType.put(UUID.class, DataType.uuid());
        return classToDataType;
    }

    private static Set<Class<?>> getCassandraPrimitiveTypes(CodecRegistry codecRegistry) {
        return DataType.allPrimitiveTypes().stream().map(arg_0 -> ((CodecRegistry)codecRegistry).codecFor(arg_0)).map(TypeCodec::getJavaType).map(TypeToken::getRawType).collect(Collectors.toSet());
    }

    public static DataType getDataTypeFor(DataType.Name name) {
        return nameToDataType.get(name);
    }

    @Nullable
    public static DataType getDataTypeFor(Class<?> javaClass) {
        return javaClass.isEnum() ? DataType.varchar() : classToDataType.get(javaClass);
    }

    static {
        CodecRegistry codecRegistry = CodecRegistry.DEFAULT_INSTANCE;
        HashMap primitiveWrappers = new HashMap(8);
        primitiveWrappers.put(Boolean.class, Boolean.TYPE);
        primitiveWrappers.put(Byte.class, Byte.TYPE);
        primitiveWrappers.put(Character.class, Character.TYPE);
        primitiveWrappers.put(Double.class, Double.TYPE);
        primitiveWrappers.put(Float.class, Float.TYPE);
        primitiveWrappers.put(Integer.class, Integer.TYPE);
        primitiveWrappers.put(Long.class, Long.TYPE);
        primitiveWrappers.put(Short.class, Short.TYPE);
        Set<Class<?>> simpleTypes = CassandraSimpleTypeHolder.getCassandraPrimitiveTypes(codecRegistry);
        simpleTypes.add(Number.class);
        simpleTypes.add(Row.class);
        simpleTypes.add(UDTValue.class);
        classToDataType = Collections.unmodifiableMap(CassandraSimpleTypeHolder.classToDataType(codecRegistry, primitiveWrappers));
        nameToDataType = Collections.unmodifiableMap(CassandraSimpleTypeHolder.nameToDataType());
        CASSANDRA_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new CassandraSimpleTypeHolder();
    }
}

