/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.cassandra.core.StatementFactory;
import org.springframework.data.cassandra.core.cql.QueryOptions;
import org.springframework.data.cassandra.core.cql.QueryOptionsUtil;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.repository.Query;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraQueryCreator;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.cassandra.repository.query.StringBasedQuery;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.QueryCreationException;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.PartTree;

class QueryStatementCreator {
    private static final Logger LOG = LoggerFactory.getLogger(QueryStatementCreator.class);
    private final CassandraQueryMethod queryMethod;

    Statement select(StatementFactory statementFactory, PartTree tree, MappingContext<? extends CassandraPersistentEntity<?>, CassandraPersistentProperty> mappingContext, CassandraParameterAccessor parameterAccessor) {
        CassandraQueryCreator queryCreator = new CassandraQueryCreator(tree, parameterAccessor, mappingContext);
        org.springframework.data.cassandra.core.query.Query query = (org.springframework.data.cassandra.core.query.Query)queryCreator.createQuery();
        try {
            Optional<QueryOptions> queryOptions;
            if (tree.isLimiting()) {
                query = query.limit(tree.getMaxResults().intValue());
            }
            if (this.queryMethod.getQueryAnnotation().map(Query::allowFiltering).orElse(false).booleanValue()) {
                query = query.withAllowFiltering();
            }
            if ((queryOptions = Optional.ofNullable(parameterAccessor.getQueryOptions())).isPresent()) {
                query = Optional.ofNullable(parameterAccessor.getQueryOptions()).map(query::queryOptions).orElse(query);
            } else if (this.queryMethod.hasConsistencyLevel()) {
                query = query.queryOptions(QueryOptions.builder().consistencyLevel(this.queryMethod.getRequiredAnnotatedConsistencyLevel()).build());
            }
            CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)mappingContext.getRequiredPersistentEntity(this.queryMethod.getDomainClass());
            RegularStatement statement = statementFactory.select(query, persistentEntity);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created query [%s].", statement));
            }
            return statement;
        }
        catch (RuntimeException e) {
            throw QueryCreationException.create((QueryMethod)this.queryMethod, (Throwable)e);
        }
    }

    SimpleStatement select(StringBasedQuery stringBasedQuery, CassandraParameterAccessor parameterAccessor) {
        try {
            SimpleStatement boundQuery = stringBasedQuery.bindQuery(parameterAccessor, this.queryMethod);
            Optional<QueryOptions> queryOptions = Optional.ofNullable(parameterAccessor.getQueryOptions());
            SimpleStatement queryToUse = boundQuery;
            if (queryOptions.isPresent()) {
                queryToUse = Optional.ofNullable(parameterAccessor.getQueryOptions()).map(it -> QueryOptionsUtil.addQueryOptions(boundQuery, it)).orElse(boundQuery);
            } else if (this.queryMethod.hasConsistencyLevel()) {
                queryToUse.setConsistencyLevel(this.queryMethod.getRequiredAnnotatedConsistencyLevel());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created query [%s].", queryToUse));
            }
            return queryToUse;
        }
        catch (RuntimeException e) {
            throw QueryCreationException.create((QueryMethod)this.queryMethod, (Throwable)e);
        }
    }

    @ConstructorProperties(value={"queryMethod"})
    public QueryStatementCreator(CassandraQueryMethod queryMethod) {
        this.queryMethod = queryMethod;
    }
}

