/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import com.datastax.driver.core.DataType;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateTableSpecification;
import org.springframework.data.cassandra.core.cql.keyspace.CreateUserTypeSpecification;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.core.mapping.CassandraType;
import org.springframework.data.cassandra.core.mapping.CassandraUserTypePersistentEntity;
import org.springframework.data.cassandra.core.mapping.CompositeCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.core.mapping.EntityMapping;
import org.springframework.data.cassandra.core.mapping.IndexSpecificationFactory;
import org.springframework.data.cassandra.core.mapping.Mapping;
import org.springframework.data.cassandra.core.mapping.PropertyMapping;
import org.springframework.data.cassandra.core.mapping.Table;
import org.springframework.data.cassandra.core.mapping.UserDefinedType;
import org.springframework.data.cassandra.core.mapping.UserTypeResolver;
import org.springframework.data.cassandra.core.mapping.UserTypeUtil;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.Optionals;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraMappingContext
extends AbstractMappingContext<BasicCassandraPersistentEntity<?>, CassandraPersistentProperty>
implements ApplicationContextAware,
BeanClassLoaderAware {
    private CassandraPersistentEntityMetadataVerifier verifier = new CompositeCassandraPersistentEntityMetadataVerifier();
    private CustomConversions customConversions = new CustomConversions(CustomConversions.StoreConversions.of((SimpleTypeHolder)CassandraSimpleTypeHolder.HOLDER, (Object[])new Object[0]), Collections.emptyList());
    private Mapping mapping = new Mapping();
    @Nullable
    private UserTypeResolver userTypeResolver;
    @Nullable
    private ApplicationContext context;
    @Nullable
    private ClassLoader beanClassLoader;
    private final Map<CqlIdentifier, Set<CassandraPersistentEntity<?>>> entitySetsByTableName = new HashMap();
    private final Set<BasicCassandraPersistentEntity<?>> userDefinedTypes = new HashSet();
    private final Set<BasicCassandraPersistentEntity<?>> tableEntities = new HashSet();

    public CassandraMappingContext() {
        this.setCustomConversions(new CustomConversions(CustomConversions.StoreConversions.of((SimpleTypeHolder)CassandraSimpleTypeHolder.HOLDER, (Object[])new Object[0]), Collections.emptyList()));
        this.setSimpleTypeHolder(CassandraSimpleTypeHolder.HOLDER);
    }

    public void initialize() {
        super.initialize();
        this.processMappingOverrides();
    }

    private void processMappingOverrides() {
        this.mapping.getEntityMappings().stream().filter(Objects::nonNull).forEach(entityMapping -> {
            Class<?> entityClass = this.getEntityClass(entityMapping.getEntityClassName());
            CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getRequiredPersistentEntity(entityClass);
            String entityTableName = entityMapping.getTableName();
            if (StringUtils.hasText((String)entityTableName)) {
                entity.setTableName(CqlIdentifier.of(entityTableName, Boolean.valueOf(entityMapping.getForceQuote())));
            }
            CassandraMappingContext.processMappingOverrides(entity, entityMapping);
        });
    }

    private Class<?> getEntityClass(String entityClassName) {
        try {
            return ClassUtils.forName((String)entityClassName, (ClassLoader)this.beanClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(String.format("Unknown persistent entity name [%s]", entityClassName), e);
        }
    }

    private static void processMappingOverrides(CassandraPersistentEntity<?> entity, EntityMapping entityMapping) {
        entityMapping.getPropertyMappings().forEach((key, propertyMapping) -> CassandraMappingContext.processMappingOverride(entity, propertyMapping));
    }

    private static void processMappingOverride(CassandraPersistentEntity<?> entity, PropertyMapping mapping) {
        CassandraPersistentProperty property = (CassandraPersistentProperty)entity.getRequiredPersistentProperty(mapping.getPropertyName());
        boolean forceQuote = Boolean.valueOf(mapping.getForceQuote());
        property.setForceQuote(forceQuote);
        if (StringUtils.hasText((String)mapping.getColumnName())) {
            property.setColumnName(CqlIdentifier.of(mapping.getColumnName(), forceQuote));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void setCustomConversions(CustomConversions customConversions) {
        Assert.notNull((Object)customConversions, (String)"CustomConversions must not be null");
        this.customConversions = customConversions;
    }

    public void setMapping(Mapping mapping) {
        Assert.notNull((Object)mapping, (String)"Mapping must not be null");
        this.mapping = mapping;
    }

    public void setUserTypeResolver(UserTypeResolver userTypeResolver) {
        Assert.notNull((Object)userTypeResolver, (String)"UserTypeResolver must not be null");
        this.userTypeResolver = userTypeResolver;
    }

    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    public Collection<BasicCassandraPersistentEntity<?>> getTableEntities() {
        return Collections.unmodifiableCollection(this.tableEntities);
    }

    public Collection<CassandraPersistentEntity<?>> getUserDefinedTypeEntities() {
        return Collections.unmodifiableSet(this.userDefinedTypes);
    }

    protected Optional<BasicCassandraPersistentEntity<?>> addPersistentEntity(TypeInformation<?> typeInformation) {
        Optional optional = this.shouldCreatePersistentEntityFor(typeInformation) ? super.addPersistentEntity(typeInformation) : Optional.empty();
        optional.ifPresent(entity -> {
            if (entity.isUserDefinedType()) {
                this.userDefinedTypes.add((BasicCassandraPersistentEntity<?>)entity);
            }
            Set entities = this.entitySetsByTableName.computeIfAbsent(entity.getTableName(), cqlIdentifier -> new HashSet());
            entities.add(entity);
            if (!entity.isUserDefinedType() && entity.isAnnotationPresent(Table.class)) {
                this.tableEntities.add((BasicCassandraPersistentEntity<?>)entity);
            }
        });
        return optional;
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> typeInfo) {
        return !this.customConversions.hasCustomWriteTarget(typeInfo.getType()) && super.shouldCreatePersistentEntityFor(typeInfo);
    }

    protected <T> BasicCassandraPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        BasicCassandraPersistentEntity<T> entity;
        UserDefinedType userDefinedType = (UserDefinedType)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)typeInformation.getType(), UserDefinedType.class);
        if (userDefinedType != null) {
            Assert.state((this.userTypeResolver != null ? 1 : 0) != 0, (String)"UserTypeResolver must not be null");
            entity = new CassandraUserTypePersistentEntity<T>(typeInformation, this.verifier, this.userTypeResolver);
        } else {
            entity = new BasicCassandraPersistentEntity<T>(typeInformation, this.verifier);
        }
        if (this.context != null) {
            entity.setApplicationContext(this.context);
        }
        return entity;
    }

    protected CassandraPersistentProperty createPersistentProperty(Property property, BasicCassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        BasicCassandraPersistentProperty cassandraProperty = new BasicCassandraPersistentProperty(property, owner, simpleTypeHolder, this.userTypeResolver);
        if (this.context != null) {
            cassandraProperty.setApplicationContext(this.context);
        }
        return cassandraProperty;
    }

    public boolean usesTable(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"Table name must not be null!");
        return this.entitySetsByTableName.containsKey(name);
    }

    public boolean usesUserType(CqlIdentifier name) {
        Assert.notNull((Object)name, (String)"User type name must not be null!");
        return this.hasMappedUserType(name) || this.hasReferencedUserType(name);
    }

    private boolean hasReferencedUserType(CqlIdentifier identifier) {
        return this.getPersistentEntities().stream().flatMap(entity -> StreamSupport.stream(entity.spliterator(), false)).flatMap(it -> Optionals.toStream((Optional[])new Optional[]{Optional.ofNullable(it.findAnnotation(CassandraType.class))})).map(CassandraType::userTypeName).filter(StringUtils::hasText).map(CqlIdentifier::of).anyMatch(identifier::equals);
    }

    private boolean hasMappedUserType(CqlIdentifier identifier) {
        return this.userDefinedTypes.stream().map(CassandraPersistentEntity::getTableName).anyMatch(identifier::equals);
    }

    public CreateTableSpecification getCreateTableSpecificationFor(CassandraPersistentEntity<?> entity) {
        CassandraPersistentProperty property;
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        CreateTableSpecification specification = CreateTableSpecification.createTable(entity.getTableName());
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            property = (CassandraPersistentProperty)iterator.next();
            if (!property.isCompositePrimaryKey()) continue;
            CassandraPersistentEntity primaryKeyEntity = (CassandraPersistentEntity)this.getRequiredPersistentEntity(property.getRawType());
            Iterator iterator2 = primaryKeyEntity.iterator();
            while (iterator2.hasNext()) {
                CassandraPersistentProperty primaryKeyProperty = (CassandraPersistentProperty)iterator2.next();
                if (primaryKeyProperty.isPartitionKeyColumn()) {
                    specification.partitionKeyColumn(primaryKeyProperty.getColumnName(), this.getDataType(primaryKeyProperty));
                    continue;
                }
                specification.clusteredKeyColumn(primaryKeyProperty.getColumnName(), this.getDataType(primaryKeyProperty), primaryKeyProperty.getPrimaryKeyOrdering());
            }
        }
        iterator = entity.iterator();
        while (iterator.hasNext()) {
            property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) continue;
            if (property.isIdProperty() || property.isPartitionKeyColumn()) {
                specification.partitionKeyColumn(property.getColumnName(), UserTypeUtil.potentiallyFreeze(this.getDataType(property)));
                continue;
            }
            if (property.isClusterKeyColumn()) {
                specification.clusteredKeyColumn(property.getColumnName(), UserTypeUtil.potentiallyFreeze(this.getDataType(property)), property.getPrimaryKeyOrdering());
                continue;
            }
            specification.column(property.getColumnName(), UserTypeUtil.potentiallyFreeze(this.getDataType(property)));
        }
        if (specification.getPartitionKeyColumns().isEmpty()) {
            throw new MappingException(String.format("No partition key columns found in entity [%s]", entity.getType()));
        }
        return specification;
    }

    public List<CreateIndexSpecification> getCreateIndexSpecificationsFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return this.getCreateIndexSpecifications(entity.getTableName(), entity);
    }

    private List<CreateIndexSpecification> getCreateIndexSpecifications(CqlIdentifier tableName, CassandraPersistentEntity<?> entity) {
        ArrayList<CreateIndexSpecification> indexes = new ArrayList<CreateIndexSpecification>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            CassandraPersistentProperty property = (CassandraPersistentProperty)iterator.next();
            if (property.isCompositePrimaryKey()) {
                indexes.addAll(this.getCreateIndexSpecifications(tableName, (CassandraPersistentEntity)this.getRequiredPersistentEntity(property)));
                continue;
            }
            indexes.addAll(IndexSpecificationFactory.createIndexSpecifications(property));
        }
        indexes.forEach(it -> it.tableName(entity.getTableName()));
        return indexes;
    }

    public CreateUserTypeSpecification getCreateUserTypeSpecificationFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        CreateUserTypeSpecification specification = CreateUserTypeSpecification.createType(entity.getTableName());
        entity.doWithProperties(property -> specification.field(property.getColumnName(), this.getDataTypeWithUserTypeFactory((CassandraPersistentProperty)property, DataTypeProvider.FrozenLiteral)));
        if (specification.getFields().isEmpty()) {
            throw new MappingException(String.format("No fields in user type [%s]", entity.getType()));
        }
        return specification;
    }

    public DataType getDataType(CassandraPersistentProperty property) {
        return this.getDataTypeWithUserTypeFactory(property, DataTypeProvider.EntityUserType);
    }

    private DataType getDataTypeWithUserTypeFactory(CassandraPersistentProperty property, DataTypeProvider dataTypeProvider) {
        DataType dataType;
        if (property.isAnnotationPresent(CassandraType.class)) {
            return property.getDataType();
        }
        BasicCassandraPersistentEntity persistentEntity = (BasicCassandraPersistentEntity)this.getPersistentEntity(property.getActualType());
        if (persistentEntity != null && persistentEntity.isUserDefinedType() && (dataType = this.getUserDataType(property, dataTypeProvider, persistentEntity)) != null) {
            return dataType;
        }
        return this.customConversions.getCustomWriteTarget(property.getType()).map(CassandraSimpleTypeHolder::getDataTypeFor).orElseGet(() -> this.customConversions.getCustomWriteTarget(property.getActualType()).filter(it -> !property.isMapLike()).map(it -> {
            if (property.isCollectionLike()) {
                if (List.class.isAssignableFrom(property.getType())) {
                    return DataType.list((DataType)CassandraSimpleTypeHolder.getDataTypeFor(it));
                }
                if (Set.class.isAssignableFrom(property.getType())) {
                    return DataType.set((DataType)CassandraSimpleTypeHolder.getDataTypeFor(it));
                }
            }
            return CassandraSimpleTypeHolder.getDataTypeFor(it);
        }).orElseGet(() -> {
            if (property.isMapLike()) {
                Class keyType = property.getComponentType();
                Class valueType = property.getMapValueType();
                return DataType.map((DataType)this.getDataType(keyType, dataTypeProvider), (DataType)this.getDataType(valueType, dataTypeProvider));
            }
            return property.getDataType();
        }));
    }

    private DataType getDataType(Class<?> type, DataTypeProvider dataTypeProvider) {
        BasicCassandraPersistentEntity entity = (BasicCassandraPersistentEntity)this.getPersistentEntity(type);
        return entity != null && entity.isUserDefinedType() ? dataTypeProvider.getDataType(entity) : this.getDataType(type);
    }

    @Nullable
    private DataType getUserDataType(CassandraPersistentProperty property, DataTypeProvider dataTypeProvider, CassandraPersistentEntity<?> persistentEntity) {
        DataType elementType = dataTypeProvider.getDataType(persistentEntity);
        if (property.isCollectionLike()) {
            if (Set.class.isAssignableFrom(property.getType())) {
                return DataType.set((DataType)elementType);
            }
            if (List.class.isAssignableFrom(property.getType())) {
                return DataType.list((DataType)elementType);
            }
        }
        if (!property.isCollectionLike() && !property.isMapLike()) {
            return elementType;
        }
        return null;
    }

    public DataType getDataType(Class<?> type) {
        return this.customConversions.getCustomWriteTarget(type).map(CassandraSimpleTypeHolder::getDataTypeFor).orElseGet(() -> CassandraSimpleTypeHolder.getDataTypeFor(type));
    }

    static enum DataTypeProvider {
        EntityUserType{

            @Override
            public DataType getDataType(CassandraPersistentEntity<?> entity) {
                return entity.getUserType();
            }
        }
        ,
        FrozenLiteral{

            @Override
            public DataType getDataType(CassandraPersistentEntity<?> entity) {
                return new UserTypeUtil.FrozenLiteralDataType(entity.getTableName());
            }
        };


        abstract DataType getDataType(CassandraPersistentEntity<?> var1);
    }
}

