/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.Session;
import java.util.Collections;
import java.util.Set;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.cassandra.SessionFactory;
import org.springframework.data.cassandra.config.AbstractClusterConfiguration;
import org.springframework.data.cassandra.config.CassandraEntityClassScanner;
import org.springframework.data.cassandra.config.CassandraSessionFactoryBean;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.core.CassandraAdminOperations;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.core.convert.CassandraConverter;
import org.springframework.data.cassandra.core.convert.CassandraCustomConversions;
import org.springframework.data.cassandra.core.convert.MappingCassandraConverter;
import org.springframework.data.cassandra.core.cql.session.DefaultSessionFactory;
import org.springframework.data.cassandra.core.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.core.mapping.SimpleUserTypeResolver;
import org.springframework.data.convert.CustomConversions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@Configuration
public abstract class AbstractCassandraConfiguration
extends AbstractClusterConfiguration
implements BeanClassLoaderAware {
    @Nullable
    private ClassLoader beanClassLoader;

    protected Session getRequiredSession() {
        CassandraSessionFactoryBean factoryBean = this.session();
        Assert.state((factoryBean.getObject() != null ? 1 : 0) != 0, (String)"Session factory not initialized");
        return factoryBean.getObject();
    }

    @Bean
    public CassandraSessionFactoryBean session() {
        CassandraSessionFactoryBean session = new CassandraSessionFactoryBean();
        session.setCluster(this.getRequiredCluster());
        session.setConverter(this.cassandraConverter());
        session.setKeyspaceName(this.getKeyspaceName());
        session.setSchemaAction(this.getSchemaAction());
        session.setStartupScripts(this.getStartupScripts());
        session.setShutdownScripts(this.getShutdownScripts());
        return session;
    }

    @Bean
    public SessionFactory sessionFactory() {
        return new DefaultSessionFactory(this.getRequiredSession());
    }

    @Bean
    public CassandraConverter cassandraConverter() {
        try {
            MappingCassandraConverter mappingCassandraConverter = new MappingCassandraConverter(this.cassandraMapping());
            mappingCassandraConverter.setCustomConversions(this.customConversions());
            return mappingCassandraConverter;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Bean
    public CustomConversions customConversions() {
        return new CassandraCustomConversions(Collections.emptyList());
    }

    @Bean
    public CassandraMappingContext cassandraMapping() throws ClassNotFoundException {
        CassandraMappingContext mappingContext = new CassandraMappingContext();
        if (this.beanClassLoader != null) {
            mappingContext.setBeanClassLoader(this.beanClassLoader);
        }
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        CustomConversions customConversions = this.customConversions();
        mappingContext.setCustomConversions(customConversions);
        mappingContext.setSimpleTypeHolder(customConversions.getSimpleTypeHolder());
        mappingContext.setUserTypeResolver(new SimpleUserTypeResolver(this.getRequiredCluster(), this.getKeyspaceName()));
        return mappingContext;
    }

    protected Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        return CassandraEntityClassScanner.scan(this.getEntityBasePackages());
    }

    @Bean
    public CassandraAdminOperations cassandraTemplate() throws Exception {
        return new CassandraAdminTemplate(this.sessionFactory(), this.cassandraConverter());
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public String[] getEntityBasePackages() {
        return new String[]{this.getClass().getPackage().getName()};
    }

    protected abstract String getKeyspaceName();

    public SchemaAction getSchemaAction() {
        return SchemaAction.NONE;
    }
}

