/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.annotation.Persistent;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class CassandraEntityClassScanner {
    protected Set<String> entityBasePackages = new HashSet<String>();
    protected Set<Class<?>> entityBasePackageClasses = new HashSet();
    protected ClassLoader beanClassLoader;

    public static Set<Class<?>> scan(String ... entityBasePackages) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Class<?> ... entityBasePackageClasses) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackageClasses).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Collection<String> entityBasePackages) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages).scanForEntityClasses();
    }

    public static Set<Class<?>> scan(Collection<String> entityBasePackages, Collection<Class<?>> entityBasePackageClasses) throws ClassNotFoundException {
        return new CassandraEntityClassScanner(entityBasePackages, entityBasePackageClasses).scanForEntityClasses();
    }

    public CassandraEntityClassScanner() {
    }

    public CassandraEntityClassScanner(Class<?> ... entityBasePackageClasses) {
        this(null, Arrays.asList(entityBasePackageClasses));
    }

    public CassandraEntityClassScanner(String ... entityBasePackages) {
        this(Arrays.asList(entityBasePackages));
    }

    public CassandraEntityClassScanner(Collection<String> entityBasePackages) {
        this(entityBasePackages, null);
    }

    public CassandraEntityClassScanner(Collection<String> entityBasePackages, Collection<Class<?>> entityBasePackageClasses) {
        this.setEntityBasePackages(entityBasePackages);
        this.setEntityBasePackageClasses(entityBasePackageClasses);
    }

    public Set<String> getEntityBasePackages() {
        return Collections.unmodifiableSet(this.entityBasePackages);
    }

    public void setEntityBasePackages(Collection<String> entityBasePackages) {
        this.entityBasePackages = entityBasePackages == null ? new HashSet<String>() : new HashSet<String>(entityBasePackages);
    }

    public Set<Class<?>> getEntityBasePackageClasses() {
        return Collections.unmodifiableSet(this.entityBasePackageClasses);
    }

    public void setEntityBasePackageClasses(Collection<Class<?>> entityBasePackageClasses) {
        this.entityBasePackageClasses = entityBasePackageClasses == null ? new HashSet() : new HashSet(entityBasePackageClasses);
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public Set<Class<?>> scanForEntityClasses() throws ClassNotFoundException {
        HashSet classes = new HashSet();
        for (String string : this.getEntityBasePackages()) {
            classes.addAll(this.scanBasePackageForEntities(string));
        }
        for (Class clazz : this.getEntityBasePackageClasses()) {
            classes.addAll(this.scanBasePackageForEntities(clazz.getPackage().getName()));
        }
        return classes;
    }

    protected Set<Class<?>> scanBasePackageForEntities(String basePackage) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        if (StringUtils.hasText((String)basePackage)) {
            ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
            for (Class<? extends Annotation> annoClass : this.getEntityAnnotations()) {
                componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annoClass));
            }
            for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
                classes.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)this.beanClassLoader));
            }
        }
        return classes;
    }

    public Class<? extends Annotation>[] getEntityAnnotations() {
        return new Class[]{Table.class, Persistent.class, PrimaryKeyClass.class};
    }
}

