/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import com.datastax.driver.core.DataType;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.cassandra.repository.query.CassandraParameterAccessor;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.cassandra.repository.query.CassandraQueryMethod;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;

public class CassandraParametersParameterAccessor
extends ParametersParameterAccessor
implements CassandraParameterAccessor {
    private final List<Object> values;

    public CassandraParametersParameterAccessor(CassandraQueryMethod method, Object ... values) {
        super((Parameters)method.getParameters(), values);
        this.values = Arrays.asList(values);
    }

    @Override
    public DataType getDataType(int index) {
        CassandraType cassandraType = this.findCassandraType(index);
        return cassandraType != null ? CassandraSimpleTypeHolder.getDataTypeFor(cassandraType.type()) : CassandraSimpleTypeHolder.getDataTypeFor(this.getParameterType(index));
    }

    @Override
    public CassandraType findCassandraType(int index) {
        return ((CassandraParameters.CassandraParameter)this.getParameters().getParameter(index)).getCassandraType();
    }

    @Override
    public Class<?> getParameterType(int index) {
        return ((CassandraParameters.CassandraParameter)this.getParameters().getParameter(index)).getType();
    }

    public CassandraParameters getParameters() {
        return (CassandraParameters)super.getParameters();
    }

    @Override
    public Object[] getValues() {
        return this.values.toArray();
    }
}

