/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import com.datastax.driver.core.UserType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.support.exception.UnsupportedCassandraOperationException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraPersistentPropertyComparator;
import org.springframework.data.cassandra.mapping.CompositeCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.PrimaryKeyClass;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.data.cassandra.util.SpelUtils;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicCassandraPersistentEntity<T>
extends BasicPersistentEntity<T, CassandraPersistentProperty>
implements CassandraPersistentEntity<T>,
ApplicationContextAware {
    protected static final CassandraPersistentEntityMetadataVerifier DEFAULT_VERIFIER = new CompositeCassandraPersistentEntityMetadataVerifier();
    protected ApplicationContext context;
    protected Boolean forceQuote;
    protected CassandraMappingContext mappingContext;
    protected CassandraPersistentEntityMetadataVerifier verifier = DEFAULT_VERIFIER;
    protected CqlIdentifier tableName;
    protected StandardEvaluationContext spelContext;

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation) {
        this(typeInformation, null, DEFAULT_VERIFIER);
    }

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation, CassandraMappingContext mappingContext) {
        this(typeInformation, mappingContext, DEFAULT_VERIFIER);
    }

    public BasicCassandraPersistentEntity(TypeInformation<T> typeInformation, CassandraMappingContext mappingContext, CassandraPersistentEntityMetadataVerifier verifier) {
        super(typeInformation, (Comparator)CassandraPersistentPropertyComparator.INSTANCE);
        this.mappingContext = mappingContext;
        this.setVerifier(verifier);
    }

    protected CqlIdentifier determineTableName() {
        Table tableAnnotation = (Table)this.findAnnotation(Table.class);
        return tableAnnotation != null ? this.determineName(tableAnnotation.value(), tableAnnotation.forceQuote()) : this.determineDefaultName();
    }

    public void addAssociation(Association<CassandraPersistentProperty> association) {
        throw new UnsupportedCassandraOperationException("Cassandra does not support associations");
    }

    public void doWithAssociations(AssociationHandler<CassandraPersistentProperty> handler) {
        throw new UnsupportedCassandraOperationException("Cassandra does not support associations");
    }

    @Override
    public boolean isCompositePrimaryKey() {
        return this.findAnnotation(PrimaryKeyClass.class) != null;
    }

    @Override
    public List<CassandraPersistentProperty> getCompositePrimaryKeyProperties() {
        ArrayList<CassandraPersistentProperty> properties = new ArrayList<CassandraPersistentProperty>();
        Assert.state((boolean)this.isCompositePrimaryKey(), (String)String.format("[%s] does not represent a composite primary key class", this.getType().getName()));
        this.addCompositePrimaryKeyProperties(this, properties);
        return properties;
    }

    protected void addCompositePrimaryKeyProperties(CassandraPersistentEntity<?> compositePrimaryKeyEntity, final List<CassandraPersistentProperty> properties) {
        compositePrimaryKeyEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isCompositePrimaryKey()) {
                    BasicCassandraPersistentEntity.this.addCompositePrimaryKeyProperties(property.getCompositePrimaryKeyEntity(), properties);
                } else {
                    properties.add(property);
                }
            }
        });
    }

    public void verify() throws MappingException {
        super.verify();
        if (this.verifier != null) {
            this.verifier.verify(this);
        }
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        Assert.notNull((Object)context, (String)"ApplicationContext must not be null");
        this.context = context;
        this.spelContext = new StandardEvaluationContext();
        this.spelContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
        this.spelContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)context));
        this.spelContext.setRootObject((Object)context);
    }

    @Override
    public ApplicationContext getApplicationContext() {
        return this.context;
    }

    @Override
    public void setForceQuote(boolean forceQuote) {
        if (this.forceQuote == null || this.forceQuote != forceQuote) {
            this.forceQuote = forceQuote;
            this.setTableName(CqlIdentifier.cqlId((CharSequence)this.tableName.getUnquoted(), (boolean)forceQuote));
        }
    }

    @Override
    public CassandraMappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public void setTableName(CqlIdentifier tableName) {
        Assert.notNull((Object)tableName);
        this.tableName = tableName;
    }

    @Override
    public CqlIdentifier getTableName() {
        this.tableName = this.tableName != null ? this.tableName : this.determineTableName();
        return this.tableName;
    }

    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    @Override
    public boolean isUserDefinedType() {
        return false;
    }

    @Override
    public UserType getUserType() {
        return null;
    }

    protected CqlIdentifier determineDefaultName() {
        return CqlIdentifier.cqlId((CharSequence)this.getType().getSimpleName(), (boolean)false);
    }

    protected CqlIdentifier determineName(String value, boolean forceQuote) {
        if (!StringUtils.hasText((String)value)) {
            return CqlIdentifier.cqlId((CharSequence)this.getType().getSimpleName(), (boolean)forceQuote);
        }
        return CqlIdentifier.cqlId((CharSequence)(this.spelContext == null ? value : SpelUtils.evaluate(value, (EvaluationContext)this.spelContext)), (boolean)forceQuote);
    }
}

