/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.UserType;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.BeansException;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.cassandra.core.keyspace.CreateTableSpecification;
import org.springframework.cassandra.core.keyspace.CreateUserTypeSpecification;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.convert.CustomConversions;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.BasicCassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraSimpleTypeHolder;
import org.springframework.data.cassandra.mapping.CassandraType;
import org.springframework.data.cassandra.mapping.CassandraUserTypePersistentEntity;
import org.springframework.data.cassandra.mapping.CompositeCassandraPersistentEntityMetadataVerifier;
import org.springframework.data.cassandra.mapping.EntityMapping;
import org.springframework.data.cassandra.mapping.Mapping;
import org.springframework.data.cassandra.mapping.PropertyMapping;
import org.springframework.data.cassandra.mapping.Table;
import org.springframework.data.cassandra.mapping.UserDefinedType;
import org.springframework.data.cassandra.mapping.UserTypeResolver;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class BasicCassandraMappingContext
extends AbstractMappingContext<CassandraPersistentEntity<?>, CassandraPersistentProperty>
implements CassandraMappingContext,
ApplicationContextAware {
    protected ApplicationContext context;
    protected CassandraPersistentEntityMetadataVerifier verifier = new CompositeCassandraPersistentEntityMetadataVerifier();
    protected ClassLoader beanClassLoader;
    protected Mapping mapping = new Mapping();
    protected Map<Class<?>, CassandraPersistentEntity<?>> entitiesByType = new HashMap();
    protected Map<CqlIdentifier, Set<CassandraPersistentEntity<?>>> entitySetsByTableName = new HashMap();
    protected Set<CassandraPersistentEntity<?>> primaryKeyEntities = new HashSet();
    protected Set<CassandraPersistentEntity<?>> userDefinedTypes = new HashSet();
    protected Set<CassandraPersistentEntity<?>> tableEntities = new HashSet();
    private CustomConversions customConversions;
    private UserTypeResolver userTypeResolver;

    public BasicCassandraMappingContext() {
        this.setCustomConversions(new CustomConversions(Collections.EMPTY_LIST));
        this.setSimpleTypeHolder(CassandraSimpleTypeHolder.HOLDER);
    }

    public void initialize() {
        super.initialize();
        this.processMappingOverrides();
    }

    protected void processMappingOverrides() {
        if (this.mapping != null) {
            for (EntityMapping entityMapping : this.mapping.getEntityMappings()) {
                if (entityMapping == null) continue;
                String entityClassName = entityMapping.getEntityClassName();
                try {
                    Class entityClass = ClassUtils.forName((String)entityClassName, (ClassLoader)this.beanClassLoader);
                    CassandraPersistentEntity entity = (CassandraPersistentEntity)this.getPersistentEntity(entityClass);
                    Assert.state((entity != null ? 1 : 0) != 0, (String)String.format("Unknown persistent entity class name [%s]", entityClassName));
                    String entityTableName = entityMapping.getTableName();
                    if (StringUtils.hasText((String)entityTableName)) {
                        entity.setTableName(CqlIdentifier.cqlId((CharSequence)entityTableName, (boolean)Boolean.valueOf(entityMapping.getForceQuote())));
                    }
                    this.processMappingOverrides(entity, entityMapping);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(String.format("Unknown persistent entity name [%s]", entityClassName), e);
                }
            }
        }
    }

    protected void processMappingOverrides(CassandraPersistentEntity<?> entity, EntityMapping entityMapping) {
        for (PropertyMapping mapping : entityMapping.getPropertyMappings().values()) {
            this.processMappingOverride(entity, mapping);
        }
    }

    protected void processMappingOverride(CassandraPersistentEntity<?> entity, PropertyMapping mapping) {
        CassandraPersistentProperty property = (CassandraPersistentProperty)entity.getPersistentProperty(mapping.getPropertyName());
        Assert.notNull((Object)property, (String)String.format("Entity class [%s] has no persistent property named [%s]", entity.getType().getName(), mapping.getPropertyName()));
        boolean forceQuote = Boolean.valueOf(mapping.getForceQuote());
        property.setForceQuote(forceQuote);
        if (StringUtils.hasText((String)mapping.getColumnName())) {
            property.setColumnName(CqlIdentifier.cqlId((CharSequence)mapping.getColumnName(), (boolean)forceQuote));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void setCustomConversions(CustomConversions customConversions) {
        Assert.notNull((Object)customConversions, (String)"CustomConversions must not be null");
        this.customConversions = customConversions;
    }

    public void setMapping(Mapping mapping) {
        Assert.notNull((Object)mapping, (String)"Mapping must not be null");
        this.mapping = mapping;
    }

    public void setUserTypeResolver(UserTypeResolver userTypeResolver) {
        Assert.notNull((Object)userTypeResolver, (String)"UserTypeResolver must not be null");
        this.userTypeResolver = userTypeResolver;
    }

    @Override
    public void setVerifier(CassandraPersistentEntityMetadataVerifier verifier) {
        this.verifier = verifier;
    }

    public CassandraPersistentEntityMetadataVerifier getVerifier() {
        return this.verifier;
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getNonPrimaryKeyEntities() {
        return this.getTableEntities();
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getPrimaryKeyEntities() {
        return Collections.unmodifiableSet(this.primaryKeyEntities);
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getTableEntities() {
        return Collections.unmodifiableCollection(this.tableEntities);
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getUserDefinedTypeEntities() {
        return Collections.unmodifiableSet(this.userDefinedTypes);
    }

    @Override
    public Collection<CassandraPersistentEntity<?>> getPersistentEntities(boolean includePrimaryKeyTypesAndUdts) {
        if (includePrimaryKeyTypesAndUdts) {
            return super.getPersistentEntities();
        }
        return this.getTableEntities();
    }

    protected <T> CassandraPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        Set<CassandraPersistentEntity<?>> entities;
        BasicCassandraPersistentEntity<T> entity;
        UserDefinedType userDefinedType = (UserDefinedType)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)typeInformation.getType(), UserDefinedType.class);
        if (userDefinedType != null) {
            entity = new CassandraUserTypePersistentEntity<T>(typeInformation, this, this.verifier, this.userTypeResolver);
            this.userDefinedTypes.add(entity);
        } else {
            entity = new BasicCassandraPersistentEntity<T>(typeInformation, this, this.verifier);
        }
        if (this.context != null) {
            entity.setApplicationContext(this.context);
        }
        if ((entities = this.entitySetsByTableName.get(entity.getTableName())) == null) {
            entities = new HashSet();
            this.entitySetsByTableName.put(entity.getTableName(), entities);
        }
        entities.add(entity);
        if (!entity.isUserDefinedType()) {
            if (entity.isCompositePrimaryKey()) {
                this.primaryKeyEntities.add(entity);
            }
            if (entity.findAnnotation(Table.class) != null) {
                this.tableEntities.add(entity);
            }
        }
        this.entitiesByType.put(entity.getType(), entity);
        return entity;
    }

    public CassandraPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, CassandraPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return this.createPersistentProperty(field, descriptor, owner, (CassandraSimpleTypeHolder)simpleTypeHolder);
    }

    public CassandraPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, CassandraPersistentEntity<?> owner, CassandraSimpleTypeHolder simpleTypeHolder) {
        return new BasicCassandraPersistentProperty(field, descriptor, owner, simpleTypeHolder, this.userTypeResolver);
    }

    @Override
    public boolean usesTable(TableMetadata table) {
        return this.entitySetsByTableName.containsKey(CqlIdentifier.cqlId((CharSequence)table.getName()));
    }

    @Override
    public boolean usesUserType(UserType userType) {
        CqlIdentifier identifier = CqlIdentifier.cqlId((CharSequence)userType.getTypeName());
        return this.hasMappedUserType(identifier) || this.hasReferencedUserType(identifier);
    }

    private boolean hasReferencedUserType(final CqlIdentifier identifier) {
        final AtomicBoolean foundReference = new AtomicBoolean();
        for (CassandraPersistentEntity entity : this.getPersistentEntities()) {
            entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

                public void doWithPersistentProperty(CassandraPersistentProperty persistentProperty) {
                    CassandraType cassandraType = (CassandraType)persistentProperty.findAnnotation(CassandraType.class);
                    if (cassandraType == null) {
                        return;
                    }
                    if (StringUtils.hasText((String)cassandraType.userTypeName()) && CqlIdentifier.cqlId((CharSequence)cassandraType.userTypeName()).equals((Object)identifier)) {
                        foundReference.set(true);
                    }
                }
            });
        }
        return foundReference.get();
    }

    private boolean hasMappedUserType(CqlIdentifier identifier) {
        for (CassandraPersistentEntity<?> userDefinedType : this.userDefinedTypes) {
            if (!userDefinedType.getTableName().equals((Object)identifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public CreateTableSpecification getCreateTableSpecificationFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        final CreateTableSpecification specification = CreateTableSpecification.createTable().name(entity.getTableName());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                if (property.isCompositePrimaryKey()) {
                    CassandraPersistentEntity primaryKeyEntity = (CassandraPersistentEntity)BasicCassandraMappingContext.this.getPersistentEntity(property.getRawType());
                    primaryKeyEntity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

                        public void doWithPersistentProperty(CassandraPersistentProperty primaryKeyProperty) {
                            if (primaryKeyProperty.isPartitionKeyColumn()) {
                                specification.partitionKeyColumn(primaryKeyProperty.getColumnName(), BasicCassandraMappingContext.this.getDataType(primaryKeyProperty));
                            } else {
                                specification.clusteredKeyColumn(primaryKeyProperty.getColumnName(), BasicCassandraMappingContext.this.getDataType(primaryKeyProperty), primaryKeyProperty.getPrimaryKeyOrdering());
                            }
                        }
                    });
                } else if (property.isIdProperty() || property.isPartitionKeyColumn()) {
                    specification.partitionKeyColumn(property.getColumnName(), BasicCassandraMappingContext.this.getDataType(property));
                } else if (property.isClusterKeyColumn()) {
                    specification.clusteredKeyColumn(property.getColumnName(), BasicCassandraMappingContext.this.getDataType(property), property.getPrimaryKeyOrdering());
                } else {
                    specification.column(property.getColumnName(), BasicCassandraMappingContext.this.getDataType(property));
                }
            }
        });
        if (specification.getPartitionKeyColumns().isEmpty()) {
            throw new MappingException(String.format("No partition key columns found in entity [%s]", entity.getType()));
        }
        return specification;
    }

    @Override
    public CreateUserTypeSpecification getCreateUserTypeSpecificationFor(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        final CreateUserTypeSpecification specification = CreateUserTypeSpecification.createType((CqlIdentifier)entity.getTableName());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<CassandraPersistentProperty>(){

            public void doWithPersistentProperty(CassandraPersistentProperty property) {
                specification.field(property.getColumnName(), BasicCassandraMappingContext.this.getDataType(property));
            }
        });
        if (specification.getFields().isEmpty()) {
            throw new MappingException(String.format("No fields in user type [%s]", entity.getType()));
        }
        return specification;
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> typeInfo) {
        return !this.customConversions.hasCustomWriteTarget(typeInfo.getType()) && super.shouldCreatePersistentEntityFor(typeInfo);
    }

    protected CassandraPersistentEntity<?> addPersistentEntity(TypeInformation<?> typeInformation) {
        return this.shouldCreatePersistentEntityFor(typeInformation) ? (CassandraPersistentEntity)super.addPersistentEntity(typeInformation) : null;
    }

    @Override
    public DataType getDataType(CassandraPersistentProperty property) {
        if (property.isCompositePrimaryKey()) {
            return property.getDataType();
        }
        if (property.findAnnotation(CassandraType.class) != null) {
            return property.getDataType();
        }
        CassandraPersistentEntity persistentEntity = (CassandraPersistentEntity)this.getPersistentEntity(property.getType());
        if (persistentEntity != null && persistentEntity.isUserDefinedType()) {
            return persistentEntity.getUserType();
        }
        if (this.customConversions.hasCustomWriteTarget(property.getType())) {
            return CassandraSimpleTypeHolder.getDataTypeFor(this.customConversions.getCustomWriteTarget(property.getType()));
        }
        if (this.customConversions.hasCustomWriteTarget(property.getActualType())) {
            Class<?> targetType = this.customConversions.getCustomWriteTarget(property.getActualType());
            if (property.isCollectionLike()) {
                if (List.class.isAssignableFrom(property.getType())) {
                    return DataType.list((DataType)CassandraSimpleTypeHolder.getDataTypeFor(targetType));
                }
                if (Set.class.isAssignableFrom(property.getType())) {
                    return DataType.set((DataType)CassandraSimpleTypeHolder.getDataTypeFor(targetType));
                }
            }
            return CassandraSimpleTypeHolder.getDataTypeFor(targetType);
        }
        return property.getDataType();
    }

    @Override
    public DataType getDataType(Class<?> type) {
        return this.customConversions.hasCustomWriteTarget(type) ? CassandraSimpleTypeHolder.getDataTypeFor(this.customConversions.getCustomWriteTarget(type)) : CassandraSimpleTypeHolder.getDataTypeFor(type);
    }

    @Override
    public CassandraPersistentEntity<?> getExistingPersistentEntity(Class<?> type) {
        CassandraPersistentEntity<?> entity = this.entitiesByType.get(type);
        Assert.notNull(entity, (String)String.format("Unknown persistent type [%s]", type.getName()));
        return entity;
    }

    @Override
    public boolean contains(Class<?> type) {
        return this.entitiesByType.containsKey(type);
    }
}

