/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.support;

import com.datastax.driver.core.querybuilder.Select;
import java.io.Serializable;
import java.util.List;
import org.springframework.cassandra.core.util.CollectionUtils;
import org.springframework.data.cassandra.core.CassandraOperations;
import org.springframework.data.cassandra.repository.TypedIdCassandraRepository;
import org.springframework.data.cassandra.repository.query.CassandraEntityInformation;
import org.springframework.util.Assert;

public class SimpleCassandraRepository<T, ID extends Serializable>
implements TypedIdCassandraRepository<T, ID> {
    protected CassandraOperations operations;
    protected CassandraEntityInformation<T, ID> entityInformation;

    public SimpleCassandraRepository(CassandraEntityInformation<T, ID> metadata, CassandraOperations operations) {
        Assert.notNull((Object)operations);
        Assert.notNull(metadata);
        this.entityInformation = metadata;
        this.operations = operations;
    }

    public <S extends T> S save(S entity) {
        return this.operations.insert(entity);
    }

    public <S extends T> List<S> save(Iterable<S> entities) {
        return this.operations.insert(CollectionUtils.toList(entities));
    }

    public T findOne(ID id) {
        return this.operations.selectOneById(this.entityInformation.getJavaType(), id);
    }

    public boolean exists(ID id) {
        return this.operations.exists(this.entityInformation.getJavaType(), id);
    }

    public long count() {
        return this.operations.count(this.entityInformation.getTableName());
    }

    public void delete(ID id) {
        this.operations.deleteById(this.entityInformation.getJavaType(), id);
    }

    public void delete(T entity) {
        this.delete((T)this.entityInformation.getId(entity));
    }

    public void delete(Iterable<? extends T> entities) {
        this.operations.delete(CollectionUtils.toList(entities));
    }

    public void deleteAll() {
        this.operations.truncate(this.entityInformation.getTableName());
    }

    public List<T> findAll() {
        return this.operations.selectAll(this.entityInformation.getJavaType());
    }

    public Iterable<T> findAll(Iterable<ID> ids) {
        return this.operations.selectBySimpleIds(this.entityInformation.getJavaType(), ids);
    }

    protected List<T> findAll(Select query) {
        return this.operations.select(query, this.entityInformation.getJavaType());
    }
}

