/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableMetadata;
import java.util.Collection;
import org.springframework.cassandra.config.CassandraCqlSessionFactoryBean;
import org.springframework.cassandra.core.cql.CqlIdentifier;
import org.springframework.data.cassandra.config.SchemaAction;
import org.springframework.data.cassandra.convert.CassandraConverter;
import org.springframework.data.cassandra.core.CassandraAdminTemplate;
import org.springframework.data.cassandra.mapping.CassandraMappingContext;
import org.springframework.data.cassandra.mapping.CassandraPersistentEntity;
import org.springframework.util.Assert;

public class CassandraSessionFactoryBean
extends CassandraCqlSessionFactoryBean {
    protected SchemaAction schemaAction = SchemaAction.NONE;
    protected CassandraAdminTemplate admin;
    protected CassandraConverter converter;
    protected CassandraMappingContext mappingContext;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.converter);
        this.admin = new CassandraAdminTemplate(this.session, this.converter);
        this.performSchemaAction();
    }

    protected void performSchemaAction() {
        boolean dropTables = false;
        boolean dropUnused = false;
        switch (this.schemaAction) {
            case NONE: {
                return;
            }
            case RECREATE_DROP_UNUSED: {
                dropUnused = true;
            }
            case RECREATE: {
                dropTables = true;
            }
            case CREATE: {
                this.createTables(dropTables, dropUnused);
            }
        }
    }

    protected void createTables(boolean dropTables, boolean dropUnused) {
        Metadata md = this.session.getCluster().getMetadata();
        KeyspaceMetadata kmd = md.getKeyspace(this.keyspaceName);
        if (kmd == null) {
            kmd = md.getKeyspace(this.keyspaceName.toLowerCase());
        }
        if (kmd == null) {
            throw new IllegalStateException(String.format("keyspace [%s] does not exist", this.keyspaceName));
        }
        for (TableMetadata table : kmd.getTables()) {
            if (!dropTables || !dropUnused && !this.mappingContext.usesTable(table)) continue;
            this.admin.dropTable(CqlIdentifier.cqlId((CharSequence)table.getName()));
        }
        Collection<CassandraPersistentEntity<?>> entities = this.converter.getMappingContext().getNonPrimaryKeyEntities();
        for (CassandraPersistentEntity<?> entity : entities) {
            this.admin.createTable(false, entity.getTableName(), entity.getType(), null);
        }
    }

    public SchemaAction getSchemaAction() {
        return this.schemaAction;
    }

    public void setSchemaAction(SchemaAction schemaAction) {
        Assert.notNull((Object)((Object)schemaAction));
        this.schemaAction = schemaAction;
    }

    public CassandraConverter getConverter() {
        return this.converter;
    }

    public void setConverter(CassandraConverter converter) {
        Assert.notNull((Object)converter);
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }
}

