/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.mapping;

import java.lang.reflect.Field;
import java.util.Comparator;
import org.springframework.data.cassandra.mapping.CassandraColumnAnnotationComparator;
import org.springframework.data.cassandra.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.mapping.CassandraPrimaryKeyColumnAnnotationComparator;
import org.springframework.data.cassandra.mapping.Column;
import org.springframework.data.cassandra.mapping.PrimaryKeyColumn;

public enum CassandraPersistentPropertyComparator implements Comparator<CassandraPersistentProperty>
{
    IT;


    @Override
    public int compare(CassandraPersistentProperty left, CassandraPersistentProperty right) {
        boolean rightIsKey;
        if (left != null && right == null) {
            return 1;
        }
        if (left == null && right != null) {
            return -1;
        }
        if (left == null && right == null) {
            return 0;
        }
        if (left.equals(right)) {
            return 0;
        }
        boolean leftIsCompositePrimaryKey = left.isCompositePrimaryKey();
        boolean rightIsCompositePrimaryKey = right.isCompositePrimaryKey();
        if (leftIsCompositePrimaryKey && rightIsCompositePrimaryKey) {
            return 0;
        }
        boolean leftIsPrimaryKey = left.isPrimaryKeyColumn();
        boolean rightIsPrimaryKey = right.isPrimaryKeyColumn();
        Field leftField = left.getField();
        Field rightField = right.getField();
        if (leftIsPrimaryKey && rightIsPrimaryKey) {
            return CassandraPrimaryKeyColumnAnnotationComparator.IT.compare(leftField.getAnnotation(PrimaryKeyColumn.class), rightField.getAnnotation(PrimaryKeyColumn.class));
        }
        boolean leftIsKey = leftIsCompositePrimaryKey || leftIsPrimaryKey;
        boolean bl = rightIsKey = rightIsCompositePrimaryKey || rightIsPrimaryKey;
        if (leftIsKey && !rightIsKey) {
            return -1;
        }
        if (!leftIsKey && rightIsKey) {
            return 1;
        }
        Column leftColumn = leftField.getAnnotation(Column.class);
        Column rightColumn = rightField.getAnnotation(Column.class);
        if (leftColumn == null && rightColumn == null) {
            return leftField.getName().compareTo(rightField.getName());
        }
        if (leftColumn != null && rightColumn != null) {
            return CassandraColumnAnnotationComparator.IT.compare(leftColumn, rightColumn);
        }
        if (leftColumn != null && rightColumn == null) {
            return leftColumn.value().compareTo(rightField.getName());
        }
        return leftField.getName().compareTo(rightColumn.value());
    }
}

